/*
 * @Description: None
 * @Author: LILYGO_L
 * @Date: 2024-11-11 11:36:49
 * @LastEditTime: 2025-06-03 17:37:08
 * @License: GPL 3.0
 */
#pragma once

#ifdef CONFIG_BOARD_TYPE_LILYGO_T_CAMERAPLUS_S3_V1_0_V1_1
#define T_CameraPlus_S3_V1_0_V1_1
#elif defined CONFIG_BOARD_TYPE_LILYGO_T_CAMERAPLUS_S3_V1_2
#define T_CameraPlus_S3_V1_2
#endif

#ifdef T_CameraPlus_S3_V1_0_V1_1

// SPI
#define SPI_SCLK GPIO_NUM_36
#define SPI_MOSI GPIO_NUM_35
#define SPI_MISO GPIO_NUM_37

// IIC
#define IIC_SDA GPIO_NUM_1
#define IIC_SCL GPIO_NUM_2

// MSM261
#define MSM261_BCLK GPIO_NUM_18
#define MSM261_WS GPIO_NUM_39
#define MSM261_DATA GPIO_NUM_40

// MAX98357A
#define MAX98357A_DATA GPIO_NUM_38

// FP-133H01D
#define LCD_CS GPIO_NUM_34
#define LCD_RST GPIO_NUM_33

// OV2640
#define OV2640_PWDN GPIO_NUM_NC
#define OV2640_RESET GPIO_NUM_3
#define OV2640_VSYNC GPIO_NUM_4

// CST816
#define TP_RST GPIO_NUM_48

// SY6970
#define SY6970_INT GPIO_NUM_47

#endif

#ifdef T_CameraPlus_S3_V1_2

// SPI
#define SPI_SCLK GPIO_NUM_35
#define SPI_MOSI GPIO_NUM_34
#define SPI_MISO GPIO_NUM_48

// IIC
#define IIC_SDA GPIO_NUM_33
#define IIC_SCL GPIO_NUM_37

// MP34DT05TR
#define MP34DT05TR_LRCLK GPIO_NUM_40
#define MP34DT05TR_DATA GPIO_NUM_38

#define MP34DT05TR_MAX98357_EN GPIO_NUM_18

// MAX98357A
#define MAX98357A_DATA GPIO_NUM_39

// FP-133H01D
#define LCD_CS GPIO_NUM_36
#define LCD_RST GPIO_NUM_NC

// OV2640
#define OV2640_PWDN GPIO_NUM_4
#define OV2640_RESET GPIO_NUM_NC
#define OV2640_VSYNC GPIO_NUM_3

// CST816
#define TP_RST GPIO_NUM_NC

#endif

// SD
#define SD_CS GPIO_NUM_21
#define SD_SCLK SPI_SCLK
#define SD_MOSI SPI_MOSI
#define SD_MISO SPI_MISO

// MAX98357A
#define MAX98357A_BCLK GPIO_NUM_41
#define MAX98357A_LRCLK GPIO_NUM_42

// FP-133H01D
#define LCD_WIDTH 240
#define LCD_HEIGHT 240
#define LCD_BL GPIO_NUM_46
#define LCD_MOSI SPI_MOSI
#define LCD_SCLK SPI_SCLK
#define LCD_DC GPIO_NUM_45

// SY6970
#define SY6970_SDA IIC_SDA
#define SY6970_SCL IIC_SCL
#define SY6970_ADDRESS 0x6A

// OV2640
#define OV2640_XCLK GPIO_NUM_7
#define OV2640_SDA GPIO_NUM_1
#define OV2640_SCL GPIO_NUM_2
#define OV2640_D9 GPIO_NUM_6
#define OV2640_D8 GPIO_NUM_8
#define OV2640_D7 GPIO_NUM_9
#define OV2640_D6 GPIO_NUM_11
#define OV2640_D5 GPIO_NUM_13
#define OV2640_D4 GPIO_NUM_15
#define OV2640_D3 GPIO_NUM_14
#define OV2640_D2 GPIO_NUM_12
#define OV2640_HREF GPIO_NUM_5
#define OV2640_PCLK GPIO_NUM_10

#define PWDN_GPIO_NUM OV2640_PWDN
#define RESET_GPIO_NUM OV2640_RESET
#define XCLK_GPIO_NUM OV2640_XCLK
#define SIOD_GPIO_NUM OV2640_SDA
#define SIOC_GPIO_NUM OV2640_SCL

#define Y9_GPIO_NUM OV2640_D9
#define Y8_GPIO_NUM OV2640_D8
#define Y7_GPIO_NUM OV2640_D7
#define Y6_GPIO_NUM OV2640_D6
#define Y5_GPIO_NUM OV2640_D5
#define Y4_GPIO_NUM OV2640_D4
#define Y3_GPIO_NUM OV2640_D3
#define Y2_GPIO_NUM OV2640_D2
#define VSYNC_GPIO_NUM OV2640_VSYNC
#define HREF_GPIO_NUM OV2640_HREF
#define PCLK_GPIO_NUM OV2640_PCLK

#define XCLK_FREQ_HZ 20000000

// CST816
#define CST816_ADDRESS 0x15
#define TP_SDA IIC_SDA
#define TP_SCL IIC_SCL
#define TP_INT GPIO_NUM_47

// AP1511B
#define AP1511B_FBC GPIO_NUM_16

// KEY
#define KEY1 GPIO_NUM_17
