/*
* Copyright 2016 The Alatsi Project Authors (https://github.com/sorkintype/alatsi)
* This Font Software is licensed under the SIL Open Font License, Version 1.1.
* And is also available with a FAQ at: http://scripts.sil.org/OFL
*/
/*******************************************************************************
 * Size: 21 px
 * Bpp: 4
 * Opts: undefined
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef LV_FONT_MONTSERRATMEDIUM_21
#define LV_FONT_MONTSERRATMEDIUM_21 1
#endif

#if LV_FONT_MONTSERRATMEDIUM_21

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x5f, 0xf0, 0x4f, 0xf0, 0x4f, 0xe0, 0x3f, 0xd0,
    0x3f, 0xd0, 0x2f, 0xc0, 0x1f, 0xb0, 0x1f, 0xb0,
    0xf, 0xa0, 0xd, 0x80, 0x0, 0x0, 0x18, 0x60,
    0x7f, 0xf1, 0x3e, 0xc0,

    /* U+0022 "\"" */
    0xaf, 0x10, 0xdd, 0xaf, 0x0, 0xdd, 0x9f, 0x0,
    0xdd, 0x9f, 0x0, 0xcc, 0x9f, 0x0, 0xcc, 0x48,
    0x0, 0x66,

    /* U+0023 "#" */
    0x0, 0x0, 0x4f, 0x30, 0x0, 0xda, 0x0, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0xf, 0x80, 0x0, 0x0,
    0x0, 0x8e, 0x0, 0x1, 0xf5, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x6, 0x88,
    0xed, 0x88, 0x8b, 0xf8, 0x88, 0x10, 0x0, 0xf,
    0x80, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x9, 0xe0, 0x0, 0x0, 0x0, 0x2f, 0x50,
    0x0, 0xbc, 0x0, 0x0, 0x0, 0x4, 0xf3, 0x0,
    0xd, 0xa0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x38, 0x8c, 0xf8, 0x88, 0x8f,
    0xb8, 0x84, 0x0, 0x0, 0xad, 0x0, 0x3, 0xf4,
    0x0, 0x0, 0x0, 0xc, 0xb0, 0x0, 0x5f, 0x20,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x7, 0xf0, 0x0,
    0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xff, 0xfe,
    0xa5, 0x0, 0x0, 0xbf, 0xfd, 0xfd, 0xef, 0xf6,
    0x0, 0x7f, 0xd2, 0xf, 0x50, 0x29, 0x10, 0xb,
    0xf5, 0x0, 0xf5, 0x0, 0x0, 0x0, 0xbf, 0x70,
    0xf, 0x50, 0x0, 0x0, 0x5, 0xff, 0x93, 0xf5,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xc6, 0x10,
    0x0, 0x0, 0x1, 0x6a, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xf, 0x77, 0xef, 0xb0, 0x0, 0x0,
    0x0, 0xf5, 0x2, 0xff, 0x10, 0x10, 0x0, 0xf,
    0x50, 0xf, 0xf2, 0xc, 0xa3, 0x0, 0xf5, 0x8,
    0xfe, 0x0, 0xbf, 0xfe, 0xcf, 0xdf, 0xff, 0x30,
    0x0, 0x39, 0xdf, 0xff, 0xe9, 0x20, 0x0, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x20,
    0x0, 0x0,

    /* U+0025 "%" */
    0x0, 0x8d, 0xfb, 0x20, 0x0, 0x0, 0x4f, 0x50,
    0x0, 0x9e, 0x53, 0xae, 0x10, 0x0, 0x1e, 0x90,
    0x0, 0xf, 0x50, 0x0, 0xe6, 0x0, 0xb, 0xd0,
    0x0, 0x2, 0xf2, 0x0, 0xc, 0x90, 0x7, 0xf3,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0xe7, 0x3, 0xf7,
    0x0, 0x0, 0x0, 0xbc, 0x20, 0x8f, 0x20, 0xdb,
    0x0, 0x0, 0x0, 0x1, 0xbf, 0xfe, 0x40, 0x9e,
    0x14, 0xdf, 0xd4, 0x0, 0x0, 0x1, 0x0, 0x5f,
    0x43, 0xf8, 0x38, 0xf2, 0x0, 0x0, 0x0, 0x1e,
    0x90, 0xab, 0x0, 0xc, 0xa0, 0x0, 0x0, 0xb,
    0xd0, 0xd, 0x80, 0x0, 0x8d, 0x0, 0x0, 0x7,
    0xf2, 0x0, 0xd7, 0x0, 0x7, 0xd0, 0x0, 0x3,
    0xf6, 0x0, 0xa, 0xb0, 0x0, 0xba, 0x0, 0x0,
    0xdb, 0x0, 0x0, 0x3f, 0x61, 0x6f, 0x30, 0x0,
    0x9e, 0x10, 0x0, 0x0, 0x5d, 0xfd, 0x50,

    /* U+0026 "&" */
    0x0, 0x0, 0x7d, 0xfe, 0xa2, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xb7, 0x9f, 0xe1, 0x0, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0x7f, 0x40, 0x0, 0x0, 0x3,
    0xfb, 0x0, 0x8, 0xf4, 0x0, 0x0, 0x0, 0xd,
    0xf4, 0x6, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xfd, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfd, 0x6e,
    0xf6, 0x0, 0x37, 0x10, 0x6, 0xfb, 0x0, 0x2d,
    0xf7, 0x9, 0xf2, 0x0, 0xef, 0x10, 0x0, 0x1c,
    0xf9, 0xfd, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xb,
    0xff, 0x50, 0x0, 0xdf, 0x90, 0x0, 0x2, 0xbf,
    0xfb, 0x0, 0x3, 0xef, 0xeb, 0xac, 0xff, 0x8a,
    0xfc, 0x0, 0x1, 0x8d, 0xff, 0xd9, 0x30, 0x9,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+0027 "'" */
    0xaf, 0x1a, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x4,
    0x80,

    /* U+0028 "(" */
    0x0, 0xcf, 0x20, 0x4f, 0xa0, 0xb, 0xf3, 0x1,
    0xfd, 0x0, 0x6f, 0x80, 0x9, 0xf5, 0x0, 0xcf,
    0x20, 0xe, 0xf1, 0x0, 0xff, 0x0, 0xf, 0xf0,
    0x0, 0xff, 0x0, 0xe, 0xf1, 0x0, 0xcf, 0x20,
    0x9, 0xf5, 0x0, 0x6f, 0x80, 0x1, 0xfd, 0x0,
    0xb, 0xf3, 0x0, 0x4f, 0xa0, 0x0, 0xcf, 0x20,

    /* U+0029 ")" */
    0x1f, 0xd0, 0x0, 0x9, 0xf6, 0x0, 0x2, 0xfd,
    0x0, 0x0, 0xcf, 0x20, 0x0, 0x7f, 0x70, 0x0,
    0x4f, 0xb0, 0x0, 0x1f, 0xe0, 0x0, 0xf, 0xf0,
    0x0, 0xe, 0xf0, 0x0, 0xe, 0xf1, 0x0, 0xe,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0x1f, 0xe0, 0x0,
    0x4f, 0xb0, 0x0, 0x7f, 0x70, 0x0, 0xcf, 0x20,
    0x2, 0xfd, 0x0, 0x9, 0xf6, 0x0, 0x1f, 0xd0,
    0x0,

    /* U+002A "*" */
    0x0, 0x6, 0xd0, 0x0, 0x16, 0x6, 0xd0, 0x35,
    0x5f, 0xda, 0xda, 0xfa, 0x1, 0xaf, 0xfd, 0x40,
    0x6, 0xef, 0xff, 0xa1, 0x6f, 0x77, 0xd4, 0xdc,
    0x1, 0x6, 0xd0, 0x1, 0x0, 0x4, 0x80, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xfd, 0x5a, 0xaa,
    0xef, 0xaa, 0xa8, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x0, 0x0,

    /* U+002C "," */
    0x5a, 0x3e, 0xfb, 0x9f, 0xa4, 0xf4, 0x8e, 0xc,
    0x90,

    /* U+002D "-" */
    0x8b, 0xbb, 0xb9, 0xcf, 0xff, 0xfd,

    /* U+002E "." */
    0x6, 0xc4, 0xf, 0xfb, 0x9, 0xf6,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x5, 0x70, 0x0, 0x0, 0x0,
    0xf, 0xd0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x0,
    0x0, 0x0, 0xbf, 0x10, 0x0, 0x0, 0x1, 0xfb,
    0x0, 0x0, 0x0, 0x6, 0xf6, 0x0, 0x0, 0x0,
    0xc, 0xf1, 0x0, 0x0, 0x0, 0x2f, 0xa0, 0x0,
    0x0, 0x0, 0x8f, 0x50, 0x0, 0x0, 0x0, 0xdf,
    0x0, 0x0, 0x0, 0x3, 0xf9, 0x0, 0x0, 0x0,
    0x9, 0xf4, 0x0, 0x0, 0x0, 0xe, 0xe0, 0x0,
    0x0, 0x0, 0x4f, 0x80, 0x0, 0x0, 0x0, 0xaf,
    0x30, 0x0, 0x0, 0x0, 0xfd, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x0, 0x0, 0x0, 0xb, 0xf2, 0x0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x6, 0xce, 0xec, 0x60, 0x0, 0x1, 0xcf,
    0xfe, 0xef, 0xfc, 0x10, 0xb, 0xfc, 0x20, 0x2,
    0xcf, 0xb0, 0x4f, 0xe0, 0x0, 0x0, 0xe, 0xf4,
    0xaf, 0x70, 0x0, 0x0, 0x7, 0xfa, 0xdf, 0x30,
    0x0, 0x0, 0x3, 0xfd, 0xff, 0x20, 0x0, 0x0,
    0x1, 0xff, 0xff, 0x20, 0x0, 0x0, 0x2, 0xff,
    0xdf, 0x30, 0x0, 0x0, 0x3, 0xfd, 0xaf, 0x70,
    0x0, 0x0, 0x7, 0xfa, 0x4f, 0xe0, 0x0, 0x0,
    0xe, 0xf4, 0xb, 0xfc, 0x20, 0x2, 0xcf, 0xb0,
    0x1, 0xcf, 0xfe, 0xef, 0xfc, 0x10, 0x0, 0x6,
    0xcf, 0xfc, 0x60, 0x0,

    /* U+0031 "1" */
    0xdf, 0xff, 0xf9, 0xac, 0xce, 0xf9, 0x0, 0x8,
    0xf9, 0x0, 0x8, 0xf9, 0x0, 0x8, 0xf9, 0x0,
    0x8, 0xf9, 0x0, 0x8, 0xf9, 0x0, 0x8, 0xf9,
    0x0, 0x8, 0xf9, 0x0, 0x8, 0xf9, 0x0, 0x8,
    0xf9, 0x0, 0x8, 0xf9, 0x0, 0x8, 0xf9, 0x0,
    0x8, 0xf9,

    /* U+0032 "2" */
    0x0, 0x5b, 0xef, 0xfc, 0x70, 0x0, 0x2d, 0xff,
    0xed, 0xff, 0xfc, 0x0, 0x4f, 0xa2, 0x0, 0x5,
    0xff, 0x70, 0x1, 0x0, 0x0, 0x0, 0x8f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0, 0x8,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xd1, 0x0,
    0x0, 0x0, 0xa, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0xbf, 0xb0, 0x0, 0x0, 0x0, 0x1c, 0xfa, 0x0,
    0x0, 0x0, 0x2, 0xdf, 0x90, 0x0, 0x0, 0x0,
    0x1e, 0xff, 0xcc, 0xcc, 0xcc, 0xc4, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xf5,

    /* U+0033 "3" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x70, 0x2c, 0xcc,
    0xcc, 0xcd, 0xff, 0x50, 0x0, 0x0, 0x0, 0xb,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xa0, 0x0,
    0x0, 0x0, 0x8, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xc3, 0x0, 0x0, 0x0, 0x56, 0x7c, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf0, 0x1, 0x0, 0x0, 0x0,
    0x3f, 0xf0, 0x6e, 0x71, 0x0, 0x3, 0xdf, 0xa0,
    0x7f, 0xff, 0xed, 0xff, 0xfd, 0x10, 0x2, 0x8c,
    0xef, 0xec, 0x60, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x0, 0x2, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0x30, 0x1,
    0x10, 0x0, 0x0, 0x1d, 0xf6, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0xbf, 0x90, 0x0, 0xf, 0xf0, 0x0,
    0x8, 0xfc, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x2c, 0xcc,
    0xcc, 0xcc, 0xcf, 0xfc, 0xc9, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0,

    /* U+0035 "5" */
    0x0, 0xdf, 0xff, 0xff, 0xff, 0x80, 0x0, 0xff,
    0xcc, 0xcc, 0xcc, 0x60, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfe,
    0xcc, 0xb9, 0x40, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0x25, 0xdf, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf4, 0x2, 0x0, 0x0, 0x0,
    0xf, 0xf2, 0x3f, 0x93, 0x0, 0x2, 0xbf, 0xd0,
    0x4e, 0xff, 0xfd, 0xef, 0xfe, 0x20, 0x0, 0x6b,
    0xef, 0xfd, 0x81, 0x0,

    /* U+0036 "6" */
    0x0, 0x3, 0x9d, 0xff, 0xd9, 0x20, 0x0, 0x9f,
    0xfe, 0xcc, 0xef, 0x40, 0x8, 0xfd, 0x40, 0x0,
    0x2, 0x0, 0x3f, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x70, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x34,
    0xbe, 0xfd, 0x92, 0x0, 0xef, 0xaf, 0xeb, 0xbe,
    0xff, 0x30, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xe0,
    0xef, 0xd0, 0x0, 0x0, 0xd, 0xf4, 0xbf, 0xa0,
    0x0, 0x0, 0xb, 0xf5, 0x6f, 0xd0, 0x0, 0x0,
    0xd, 0xf3, 0xd, 0xf9, 0x0, 0x0, 0x9f, 0xd0,
    0x2, 0xef, 0xfb, 0xbe, 0xfe, 0x20, 0x0, 0x18,
    0xcf, 0xfd, 0x81, 0x0,

    /* U+0037 "7" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x6f, 0xec,
    0xcc, 0xcc, 0xce, 0xfa, 0x6f, 0xa0, 0x0, 0x0,
    0xe, 0xf3, 0x6f, 0xa0, 0x0, 0x0, 0x7f, 0xb0,
    0x14, 0x20, 0x0, 0x0, 0xef, 0x40, 0x0, 0x0,
    0x0, 0x6, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x50, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x70, 0x0, 0x0, 0x0, 0x3,
    0xff, 0x10, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x5, 0xbe, 0xff, 0xd9, 0x20, 0x0, 0xb,
    0xff, 0xdb, 0xbe, 0xff, 0x40, 0x5, 0xfe, 0x30,
    0x0, 0x8, 0xfd, 0x0, 0x8f, 0x90, 0x0, 0x0,
    0xf, 0xf0, 0x4, 0xfd, 0x10, 0x0, 0x6, 0xfc,
    0x0, 0x8, 0xff, 0xb9, 0xad, 0xfd, 0x20, 0x0,
    0x4e, 0xff, 0xff, 0xff, 0x91, 0x0, 0x5f, 0xf7,
    0x20, 0x14, 0xcf, 0xc0, 0xd, 0xf6, 0x0, 0x0,
    0x0, 0xcf, 0x50, 0xff, 0x10, 0x0, 0x0, 0x8,
    0xf8, 0xf, 0xf3, 0x0, 0x0, 0x0, 0xaf, 0x70,
    0x9f, 0xd2, 0x0, 0x0, 0x7f, 0xf2, 0x0, 0xcf,
    0xfd, 0xbc, 0xef, 0xf5, 0x0, 0x0, 0x6b, 0xef,
    0xfd, 0x92, 0x0,

    /* U+0039 "9" */
    0x0, 0x29, 0xdf, 0xfc, 0x70, 0x0, 0x4, 0xff,
    0xeb, 0xbe, 0xfd, 0x20, 0x1f, 0xf6, 0x0, 0x0,
    0x7f, 0xd0, 0x5f, 0xb0, 0x0, 0x0, 0xc, 0xf5,
    0x5f, 0xb0, 0x0, 0x0, 0xc, 0xfa, 0x1f, 0xf6,
    0x0, 0x0, 0x7f, 0xfd, 0x6, 0xff, 0xdb, 0xbe,
    0xfa, 0xfe, 0x0, 0x3a, 0xef, 0xeb, 0x43, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf2, 0x0, 0x40, 0x0, 0x6, 0xff, 0x80,
    0x5, 0xff, 0xdd, 0xff, 0xf8, 0x0, 0x2, 0x9d,
    0xff, 0xd9, 0x30, 0x0,

    /* U+003A ":" */
    0x9, 0xf6, 0xf, 0xfb, 0x6, 0xc4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xc4, 0xf, 0xfb, 0x9, 0xf6,

    /* U+003B ";" */
    0x9, 0xf6, 0xf, 0xfb, 0x6, 0xc4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xa3, 0xe, 0xfb, 0x9, 0xfa, 0x4, 0xf4,
    0x8, 0xe0, 0xc, 0x90,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x37, 0x0, 0x0, 0x1,
    0x6d, 0xfc, 0x0, 0x4, 0xaf, 0xfd, 0x71, 0x17,
    0xef, 0xf9, 0x30, 0x0, 0x9f, 0xd5, 0x0, 0x0,
    0x0, 0x7f, 0xfc, 0x60, 0x0, 0x0, 0x1, 0x7e,
    0xff, 0xa4, 0x0, 0x0, 0x0, 0x4a, 0xff, 0xd6,
    0x0, 0x0, 0x0, 0x16, 0xdd, 0x0, 0x0, 0x0,
    0x0, 0x2,

    /* U+003D "=" */
    0x9f, 0xff, 0xff, 0xff, 0xfd, 0x5a, 0xaa, 0xaa,
    0xaa, 0xa8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xfd, 0x5a, 0xaa,
    0xaa, 0xaa, 0xa8,

    /* U+003E ">" */
    0x54, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xe8, 0x20,
    0x0, 0x0, 0x6, 0xcf, 0xfb, 0x50, 0x0, 0x0,
    0x2, 0x8e, 0xfe, 0x93, 0x0, 0x0, 0x0, 0x4b,
    0xfd, 0x0, 0x0, 0x4, 0xaf, 0xfa, 0x0, 0x28,
    0xef, 0xe9, 0x30, 0x4c, 0xff, 0xb5, 0x0, 0x0,
    0x9e, 0x82, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x0, 0x0,

    /* U+003F "?" */
    0x0, 0x6b, 0xef, 0xec, 0x60, 0x2, 0xdf, 0xfd,
    0xce, 0xff, 0xd0, 0x6f, 0x91, 0x0, 0x4, 0xff,
    0x70, 0x10, 0x0, 0x0, 0x9, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0, 0x6f,
    0xd0, 0x0, 0x0, 0x0, 0x8f, 0xd2, 0x0, 0x0,
    0x0, 0x7f, 0xd1, 0x0, 0x0, 0x0, 0x1f, 0xf2,
    0x0, 0x0, 0x0, 0x1, 0x76, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x86,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xf2, 0x0, 0x0,
    0x0, 0x3, 0xec, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x2, 0x8c, 0xef, 0xfe, 0xb7, 0x10,
    0x0, 0x0, 0x0, 0x1, 0xaf, 0xfa, 0x76, 0x68,
    0xaf, 0xf8, 0x0, 0x0, 0x0, 0x3e, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xd2, 0x0, 0x2, 0xec,
    0x10, 0x2, 0x78, 0x72, 0x6, 0x93, 0xdd, 0x10,
    0xd, 0xe1, 0x0, 0xaf, 0xff, 0xff, 0x9b, 0xf2,
    0x2e, 0xa0, 0x5f, 0x50, 0xa, 0xfb, 0x30, 0x17,
    0xff, 0xf2, 0x6, 0xf2, 0xae, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x5f, 0xf2, 0x0, 0xf6, 0xda, 0x0,
    0x8f, 0x60, 0x0, 0x0, 0xd, 0xf2, 0x0, 0xd9,
    0xf9, 0x0, 0xaf, 0x30, 0x0, 0x0, 0xb, 0xf2,
    0x0, 0xba, 0xf9, 0x0, 0x9f, 0x50, 0x0, 0x0,
    0xc, 0xf2, 0x0, 0xca, 0xdb, 0x0, 0x6f, 0x90,
    0x0, 0x0, 0x1f, 0xf2, 0x0, 0xe8, 0xae, 0x0,
    0xe, 0xf5, 0x0, 0x1, 0xcf, 0xf3, 0x5, 0xf3,
    0x4f, 0x50, 0x3, 0xff, 0xc9, 0xaf, 0xe8, 0xfd,
    0xaf, 0xb0, 0xc, 0xe1, 0x0, 0x29, 0xef, 0xe9,
    0x10, 0x9e, 0xfa, 0x10, 0x1, 0xec, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xe6, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xaf, 0xfa, 0x86, 0x78, 0xcf, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x8c, 0xef, 0xed,
    0xa5, 0x0, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x0, 0x9, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x9f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf1, 0xaf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf8, 0x3, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0xc,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xa0, 0x0,
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0xe, 0xf3, 0x0,
    0x0, 0xdf, 0x40, 0x0, 0x0, 0x6, 0xfb, 0x0,
    0x0, 0x6, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x5f, 0xea,
    0xaa, 0xaa, 0xaa, 0xcf, 0xb0, 0x0, 0xd, 0xf5,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x30, 0x4, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xfa, 0x0, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf2,

    /* U+0042 "B" */
    0xcf, 0xff, 0xff, 0xff, 0xd9, 0x20, 0xc, 0xfc,
    0xaa, 0xaa, 0xbf, 0xff, 0x40, 0xcf, 0x50, 0x0,
    0x0, 0xa, 0xfd, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0xcf, 0x50, 0x0, 0x0, 0x3, 0xfe,
    0xc, 0xf5, 0x0, 0x0, 0x15, 0xdf, 0x70, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0x90, 0xc, 0xfc, 0xaa,
    0xaa, 0xbd, 0xff, 0x90, 0xcf, 0x50, 0x0, 0x0,
    0x2, 0xdf, 0x6c, 0xf5, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0xcf, 0x50, 0x0, 0x0, 0x0, 0x6f, 0xcc,
    0xf5, 0x0, 0x0, 0x0, 0x2d, 0xf9, 0xcf, 0xca,
    0xaa, 0xab, 0xcf, 0xfd, 0x1c, 0xff, 0xff, 0xff,
    0xfe, 0xc7, 0x0,

    /* U+0043 "C" */
    0x0, 0x0, 0x5a, 0xdf, 0xfd, 0x82, 0x0, 0x0,
    0x3d, 0xff, 0xfd, 0xef, 0xff, 0x80, 0x3, 0xff,
    0xc4, 0x0, 0x1, 0x6e, 0xe1, 0x1e, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0x10, 0x7f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xf9,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x3, 0xff, 0xc4,
    0x0, 0x1, 0x6e, 0xe2, 0x0, 0x3d, 0xff, 0xfe,
    0xef, 0xff, 0x80, 0x0, 0x0, 0x5b, 0xdf, 0xfd,
    0x82, 0x0,

    /* U+0044 "D" */
    0xcf, 0xff, 0xff, 0xfe, 0xc7, 0x10, 0x0, 0xc,
    0xfd, 0xcc, 0xcc, 0xef, 0xff, 0x70, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x28, 0xff, 0x90, 0xc, 0xf5,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x60, 0xcf, 0x50,
    0x0, 0x0, 0x0, 0x6, 0xfd, 0xc, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf2, 0xcf, 0x50, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x4c, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf4, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x2c, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xd0, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0x3f, 0xf6, 0xc, 0xf5, 0x0, 0x0, 0x2, 0x8f,
    0xf9, 0x0, 0xcf, 0xdc, 0xcc, 0xce, 0xff, 0xf7,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xec, 0x72, 0x0,
    0x0,

    /* U+0045 "E" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0x9c, 0xfd, 0xcc,
    0xcc, 0xcc, 0xc7, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x50,
    0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xfa, 0xc, 0xfd,
    0xcc, 0xcc, 0xcc, 0x80, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xdc, 0xcc, 0xcc, 0xcc, 0xac,
    0xff, 0xff, 0xff, 0xff, 0xfe,

    /* U+0046 "F" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0x9c, 0xfd, 0xcc,
    0xcc, 0xcc, 0xc7, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x50,
    0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xdc, 0xcc, 0xcc, 0xc8, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0, 0xc,
    0xf5, 0x0, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x0, 0x5a, 0xdf, 0xfd, 0x93, 0x0, 0x0,
    0x3d, 0xff, 0xfe, 0xdf, 0xff, 0xa0, 0x3, 0xff,
    0xc4, 0x0, 0x0, 0x5d, 0xf3, 0x1e, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x20, 0x8f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x10, 0xff, 0x20, 0x0, 0x0, 0x0, 0x9, 0xf6,
    0xdf, 0x50, 0x0, 0x0, 0x0, 0x9, 0xf6, 0x8f,
    0xc0, 0x0, 0x0, 0x0, 0x9, 0xf6, 0x1e, 0xf9,
    0x0, 0x0, 0x0, 0x9, 0xf6, 0x3, 0xff, 0xc5,
    0x0, 0x0, 0x5d, 0xf6, 0x0, 0x3d, 0xff, 0xfe,
    0xef, 0xff, 0xc1, 0x0, 0x0, 0x5a, 0xdf, 0xfd,
    0x94, 0x0,

    /* U+0048 "H" */
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x4f, 0xdc, 0xf5,
    0x0, 0x0, 0x0, 0x4, 0xfd, 0xcf, 0x50, 0x0,
    0x0, 0x0, 0x4f, 0xdc, 0xf5, 0x0, 0x0, 0x0,
    0x4, 0xfd, 0xcf, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0xdc, 0xf5, 0x0, 0x0, 0x0, 0x4, 0xfd, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0xfd, 0xcc,
    0xcc, 0xcc, 0xcd, 0xfd, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x4f, 0xdc, 0xf5, 0x0, 0x0, 0x0, 0x4,
    0xfd, 0xcf, 0x50, 0x0, 0x0, 0x0, 0x4f, 0xdc,
    0xf5, 0x0, 0x0, 0x0, 0x4, 0xfd, 0xcf, 0x50,
    0x0, 0x0, 0x0, 0x4f, 0xdc, 0xf5, 0x0, 0x0,
    0x0, 0x4, 0xfd,

    /* U+0049 "I" */
    0xcf, 0x5c, 0xf5, 0xcf, 0x5c, 0xf5, 0xcf, 0x5c,
    0xf5, 0xcf, 0x5c, 0xf5, 0xcf, 0x5c, 0xf5, 0xcf,
    0x5c, 0xf5, 0xcf, 0x5c, 0xf5,

    /* U+004A "J" */
    0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x8c, 0xcc,
    0xcd, 0xfb, 0x0, 0x0, 0x0, 0x6, 0xfb, 0x0,
    0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0x0, 0x0, 0x0, 0x6, 0xfb, 0x0, 0x0,
    0x0, 0x6, 0xfb, 0x0, 0x0, 0x0, 0x6, 0xfb,
    0x0, 0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0,
    0x6, 0xfa, 0x1, 0x10, 0x0, 0x8, 0xf9, 0xc,
    0xd2, 0x0, 0x2f, 0xf5, 0xa, 0xff, 0xdd, 0xff,
    0xc0, 0x0, 0x5c, 0xff, 0xd8, 0x0,

    /* U+004B "K" */
    0xcf, 0x50, 0x0, 0x0, 0x4, 0xff, 0x30, 0xcf,
    0x50, 0x0, 0x0, 0x4f, 0xf3, 0x0, 0xcf, 0x50,
    0x0, 0x4, 0xff, 0x30, 0x0, 0xcf, 0x50, 0x0,
    0x5f, 0xf3, 0x0, 0x0, 0xcf, 0x50, 0x5, 0xff,
    0x30, 0x0, 0x0, 0xcf, 0x50, 0x5f, 0xf3, 0x0,
    0x0, 0x0, 0xcf, 0x55, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0xcf, 0xaf, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0x34, 0xff, 0x50, 0x0, 0x0, 0xcf,
    0xf3, 0x0, 0x6f, 0xf3, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x8, 0xfe, 0x20, 0x0, 0xcf, 0x50, 0x0,
    0x0, 0x9f, 0xd1, 0x0, 0xcf, 0x50, 0x0, 0x0,
    0xb, 0xfc, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0xcf, 0xa0,

    /* U+004C "L" */
    0xcf, 0x50, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x50,
    0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x50, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xdc, 0xcc, 0xcc, 0xcc, 0x3c,
    0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+004D "M" */
    0xcf, 0x30, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfd,
    0xcf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xfd,
    0xcf, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xfd,
    0xcf, 0xff, 0x20, 0x0, 0x0, 0x1, 0xff, 0xfd,
    0xcf, 0x9f, 0xb0, 0x0, 0x0, 0xa, 0xf8, 0xfd,
    0xcf, 0x3b, 0xf5, 0x0, 0x0, 0x4f, 0xb3, 0xfd,
    0xcf, 0x32, 0xfe, 0x10, 0x0, 0xdf, 0x22, 0xfd,
    0xcf, 0x30, 0x7f, 0x90, 0x8, 0xf7, 0x2, 0xfd,
    0xcf, 0x30, 0xd, 0xf3, 0x2f, 0xd0, 0x2, 0xfd,
    0xcf, 0x30, 0x3, 0xfd, 0xbf, 0x40, 0x2, 0xfd,
    0xcf, 0x30, 0x0, 0x9f, 0xf9, 0x0, 0x2, 0xfd,
    0xcf, 0x30, 0x0, 0x1e, 0xe1, 0x0, 0x2, 0xfd,
    0xcf, 0x30, 0x0, 0x2, 0x20, 0x0, 0x2, 0xfd,
    0xcf, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfd,

    /* U+004E "N" */
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x4f, 0xdc, 0xff,
    0x30, 0x0, 0x0, 0x4, 0xfd, 0xcf, 0xfe, 0x10,
    0x0, 0x0, 0x4f, 0xdc, 0xfe, 0xfd, 0x0, 0x0,
    0x4, 0xfd, 0xcf, 0x5d, 0xfb, 0x0, 0x0, 0x4f,
    0xdc, 0xf5, 0x2e, 0xf9, 0x0, 0x4, 0xfd, 0xcf,
    0x50, 0x3f, 0xf6, 0x0, 0x4f, 0xdc, 0xf5, 0x0,
    0x5f, 0xf4, 0x4, 0xfd, 0xcf, 0x50, 0x0, 0x8f,
    0xf2, 0x4f, 0xdc, 0xf5, 0x0, 0x0, 0xaf, 0xd5,
    0xfd, 0xcf, 0x50, 0x0, 0x0, 0xcf, 0xef, 0xdc,
    0xf5, 0x0, 0x0, 0x1, 0xef, 0xfd, 0xcf, 0x50,
    0x0, 0x0, 0x3, 0xff, 0xdc, 0xf5, 0x0, 0x0,
    0x0, 0x4, 0xfd,

    /* U+004F "O" */
    0x0, 0x0, 0x5a, 0xdf, 0xed, 0x93, 0x0, 0x0,
    0x0, 0x3d, 0xff, 0xfd, 0xef, 0xff, 0x90, 0x0,
    0x3, 0xff, 0xc4, 0x0, 0x1, 0x6e, 0xfc, 0x0,
    0x1e, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xdf, 0x90,
    0x7f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf2,
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf7,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf9,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf9,
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf7,
    0x8f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf2,
    0x1e, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xa0,
    0x3, 0xff, 0xc4, 0x0, 0x1, 0x6e, 0xfc, 0x0,
    0x0, 0x3d, 0xff, 0xfe, 0xef, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x5a, 0xdf, 0xed, 0x93, 0x0, 0x0,

    /* U+0050 "P" */
    0xcf, 0xff, 0xff, 0xfd, 0xa3, 0x0, 0xc, 0xfd,
    0xcc, 0xcd, 0xff, 0xf9, 0x0, 0xcf, 0x50, 0x0,
    0x0, 0x6f, 0xf6, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x5f, 0xd0, 0xcf, 0x50, 0x0, 0x0, 0x1, 0xff,
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x1f, 0xf0, 0xcf,
    0x50, 0x0, 0x0, 0x7, 0xfc, 0xc, 0xf5, 0x0,
    0x1, 0x39, 0xff, 0x40, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0x60, 0xc, 0xfd, 0xcc, 0xcc, 0xa6, 0x10,
    0x0, 0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x0, 0x5a, 0xdf, 0xed, 0x93, 0x0, 0x0,
    0x0, 0x2, 0xdf, 0xff, 0xde, 0xff, 0xf9, 0x0,
    0x0, 0x3, 0xff, 0xc4, 0x0, 0x1, 0x7e, 0xfc,
    0x0, 0x0, 0xef, 0x90, 0x0, 0x0, 0x0, 0x1d,
    0xf9, 0x0, 0x7f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf2, 0xc, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x70, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf9, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x7, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x20, 0x1f, 0xf8, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xa0, 0x0, 0x4f, 0xfb,
    0x30, 0x0, 0x6, 0xef, 0xd1, 0x0, 0x0, 0x4e,
    0xff, 0xed, 0xdf, 0xff, 0xb1, 0x0, 0x0, 0x0,
    0x16, 0xce, 0xff, 0xf9, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0x90, 0x0, 0x3a, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xef, 0xea, 0xcf, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8d, 0xfe, 0x91,
    0x0,

    /* U+0052 "R" */
    0xcf, 0xff, 0xff, 0xfd, 0xa4, 0x0, 0xc, 0xfd,
    0xcc, 0xcd, 0xff, 0xf9, 0x0, 0xcf, 0x50, 0x0,
    0x0, 0x6f, 0xf7, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x5f, 0xd0, 0xcf, 0x50, 0x0, 0x0, 0x1, 0xff,
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x1f, 0xf0, 0xcf,
    0x50, 0x0, 0x0, 0x7, 0xfc, 0xc, 0xf5, 0x0,
    0x1, 0x39, 0xff, 0x40, 0xcf, 0xff, 0xff, 0xff,
    0xfe, 0x50, 0xc, 0xfd, 0xcc, 0xcb, 0xff, 0x20,
    0x0, 0xcf, 0x50, 0x0, 0x8, 0xfb, 0x0, 0xc,
    0xf5, 0x0, 0x0, 0xc, 0xf7, 0x0, 0xcf, 0x50,
    0x0, 0x0, 0x2f, 0xf3, 0xc, 0xf5, 0x0, 0x0,
    0x0, 0x5f, 0xe1,

    /* U+0053 "S" */
    0x0, 0x5, 0xbe, 0xff, 0xda, 0x40, 0x0, 0xb,
    0xff, 0xec, 0xcf, 0xff, 0x60, 0x7, 0xfe, 0x30,
    0x0, 0x3, 0xa1, 0x0, 0xbf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf8, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xea, 0x61, 0x0, 0x0, 0x0, 0x5,
    0x9d, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x6e, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf1, 0x1, 0x0, 0x0, 0x0, 0x0, 0xff, 0x20,
    0xcc, 0x50, 0x0, 0x1, 0x9f, 0xd0, 0xa, 0xff,
    0xfd, 0xcd, 0xff, 0xe3, 0x0, 0x2, 0x8c, 0xef,
    0xec, 0x81, 0x0,

    /* U+0054 "T" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4b, 0xcc,
    0xcc, 0xff, 0xdc, 0xcc, 0xc3, 0x0, 0x0, 0xe,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x30, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x30, 0x0, 0x0,

    /* U+0055 "U" */
    0xef, 0x20, 0x0, 0x0, 0x0, 0x8f, 0x8e, 0xf2,
    0x0, 0x0, 0x0, 0x8, 0xf8, 0xef, 0x20, 0x0,
    0x0, 0x0, 0x8f, 0x8e, 0xf2, 0x0, 0x0, 0x0,
    0x8, 0xf8, 0xef, 0x20, 0x0, 0x0, 0x0, 0x8f,
    0x8e, 0xf2, 0x0, 0x0, 0x0, 0x8, 0xf8, 0xef,
    0x20, 0x0, 0x0, 0x0, 0x8f, 0x8e, 0xf2, 0x0,
    0x0, 0x0, 0x8, 0xf8, 0xef, 0x30, 0x0, 0x0,
    0x0, 0x9f, 0x7c, 0xf6, 0x0, 0x0, 0x0, 0xc,
    0xf5, 0x7f, 0xc0, 0x0, 0x0, 0x3, 0xff, 0x11,
    0xef, 0xb2, 0x0, 0x5, 0xef, 0x90, 0x3, 0xef,
    0xfe, 0xdf, 0xff, 0xb0, 0x0, 0x1, 0x8c, 0xff,
    0xeb, 0x50, 0x0,

    /* U+0056 "V" */
    0xc, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfb,
    0x5, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf4,
    0x0, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x4f, 0xd0,
    0x0, 0x6f, 0xd0, 0x0, 0x0, 0x0, 0xcf, 0x50,
    0x0, 0xe, 0xf5, 0x0, 0x0, 0x3, 0xfe, 0x0,
    0x0, 0x7, 0xfc, 0x0, 0x0, 0xa, 0xf7, 0x0,
    0x0, 0x1, 0xff, 0x30, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x0, 0x8f, 0xb0, 0x0, 0x9f, 0x80, 0x0,
    0x0, 0x0, 0x1f, 0xf2, 0x1, 0xff, 0x10, 0x0,
    0x0, 0x0, 0xa, 0xf9, 0x8, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x2f, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xef, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfc, 0x0, 0x0, 0x0,

    /* U+0057 "W" */
    0x2f, 0xf0, 0x0, 0x0, 0x0, 0x3f, 0xf1, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0xcf, 0x50, 0x0, 0x0,
    0x9, 0xff, 0x60, 0x0, 0x0, 0x8, 0xf7, 0x7,
    0xfb, 0x0, 0x0, 0x0, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0xef, 0x10, 0x1f, 0xf1, 0x0, 0x0, 0x5f,
    0x9e, 0xf1, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0xcf,
    0x60, 0x0, 0xb, 0xf3, 0x8f, 0x70, 0x0, 0x9,
    0xf6, 0x0, 0x6, 0xfb, 0x0, 0x1, 0xfd, 0x3,
    0xfd, 0x0, 0x0, 0xff, 0x10, 0x0, 0x1f, 0xf1,
    0x0, 0x6f, 0x80, 0xd, 0xf2, 0x0, 0x5f, 0xb0,
    0x0, 0x0, 0xbf, 0x70, 0xc, 0xf2, 0x0, 0x7f,
    0x80, 0xa, 0xf5, 0x0, 0x0, 0x5, 0xfc, 0x2,
    0xfc, 0x0, 0x1, 0xfe, 0x1, 0xff, 0x0, 0x0,
    0x0, 0xf, 0xf2, 0x8f, 0x70, 0x0, 0xc, 0xf3,
    0x6f, 0xa0, 0x0, 0x0, 0x0, 0xaf, 0x7e, 0xf1,
    0x0, 0x0, 0x6f, 0x9b, 0xf4, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xfb, 0x0, 0x0, 0x1, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0x50, 0x0,
    0x0, 0xa, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf0, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0x0,
    0x0,

    /* U+0058 "X" */
    0x1e, 0xf6, 0x0, 0x0, 0x0, 0x3f, 0xf2, 0x4,
    0xff, 0x20, 0x0, 0x1, 0xef, 0x50, 0x0, 0x7f,
    0xd0, 0x0, 0xb, 0xf9, 0x0, 0x0, 0xb, 0xfa,
    0x0, 0x7f, 0xc0, 0x0, 0x0, 0x1, 0xef, 0x73,
    0xfe, 0x10, 0x0, 0x0, 0x0, 0x3f, 0xfe, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xcb, 0xfa, 0x0, 0x0, 0x0,
    0x4, 0xfe, 0x21, 0xef, 0x60, 0x0, 0x0, 0x1e,
    0xf5, 0x0, 0x3f, 0xf3, 0x0, 0x0, 0xcf, 0x90,
    0x0, 0x7, 0xfd, 0x10, 0x9, 0xfc, 0x0, 0x0,
    0x0, 0xbf, 0xb0, 0x5f, 0xe2, 0x0, 0x0, 0x0,
    0x1e, 0xf7,

    /* U+0059 "Y" */
    0xc, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x50,
    0x2f, 0xf2, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x7f, 0xb0, 0x0, 0x0, 0x1e, 0xf1, 0x0, 0x0,
    0xdf, 0x60, 0x0, 0xa, 0xf6, 0x0, 0x0, 0x3,
    0xfe, 0x10, 0x4, 0xfc, 0x0, 0x0, 0x0, 0x9,
    0xfa, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0xe,
    0xf4, 0x9f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xef, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfd, 0x0, 0x0,
    0x0,

    /* U+005A "Z" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xb,
    0xcc, 0xcc, 0xcc, 0xcc, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xcc, 0xcc,
    0xcc, 0xcc, 0xc2, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3,

    /* U+005B "[" */
    0xcf, 0xff, 0x9c, 0xfb, 0xa5, 0xcf, 0x30, 0xc,
    0xf3, 0x0, 0xcf, 0x30, 0xc, 0xf3, 0x0, 0xcf,
    0x30, 0xc, 0xf3, 0x0, 0xcf, 0x30, 0xc, 0xf3,
    0x0, 0xcf, 0x30, 0xc, 0xf3, 0x0, 0xcf, 0x30,
    0xc, 0xf3, 0x0, 0xcf, 0x30, 0xc, 0xf3, 0x0,
    0xcf, 0x30, 0xc, 0xfb, 0xa5, 0xcf, 0xff, 0x90,

    /* U+005C "\\" */
    0x58, 0x0, 0x0, 0x0, 0x7, 0xf6, 0x0, 0x0,
    0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xbf, 0x10,
    0x0, 0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0xf,
    0xc0, 0x0, 0x0, 0x0, 0xaf, 0x20, 0x0, 0x0,
    0x5, 0xf8, 0x0, 0x0, 0x0, 0xe, 0xd0, 0x0,
    0x0, 0x0, 0x9f, 0x30, 0x0, 0x0, 0x3, 0xf9,
    0x0, 0x0, 0x0, 0xe, 0xe0, 0x0, 0x0, 0x0,
    0x8f, 0x40, 0x0, 0x0, 0x2, 0xfa, 0x0, 0x0,
    0x0, 0xd, 0xf0, 0x0, 0x0, 0x0, 0x7f, 0x50,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0xc,
    0xf1, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0,
    0x1, 0xfc,

    /* U+005D "]" */
    0x9f, 0xff, 0xc5, 0xab, 0xfc, 0x0, 0x3f, 0xc0,
    0x3, 0xfc, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0,
    0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x3f, 0xc0, 0x3,
    0xfc, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x3f,
    0xc0, 0x3, 0xfc, 0x0, 0x3f, 0xc0, 0x3, 0xfc,
    0x0, 0x3f, 0xc5, 0xab, 0xfc, 0x9f, 0xff, 0xc0,

    /* U+005E "^" */
    0x0, 0x0, 0x67, 0x0, 0x0, 0x0, 0x2, 0xff,
    0x60, 0x0, 0x0, 0x9, 0xeb, 0xd0, 0x0, 0x0,
    0x1f, 0x84, 0xf4, 0x0, 0x0, 0x7f, 0x10, 0xdb,
    0x0, 0x0, 0xea, 0x0, 0x7f, 0x20, 0x5, 0xf4,
    0x0, 0xf, 0x90, 0xc, 0xd0, 0x0, 0x9, 0xf1,
    0x3f, 0x60, 0x0, 0x2, 0xf7,

    /* U+005F "_" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x10,

    /* U+0060 "`" */
    0x17, 0x82, 0x0, 0x4, 0xee, 0x30, 0x0, 0x1a,
    0xf5,

    /* U+0061 "a" */
    0x4, 0xad, 0xff, 0xd8, 0x0, 0x6f, 0xfd, 0xbd,
    0xff, 0xc0, 0x1a, 0x20, 0x0, 0x2e, 0xf6, 0x0,
    0x0, 0x0, 0x7, 0xfa, 0x0, 0x0, 0x11, 0x16,
    0xfb, 0x7, 0xef, 0xff, 0xff, 0xfb, 0x8f, 0xd6,
    0x54, 0x47, 0xfb, 0xef, 0x20, 0x0, 0x4, 0xfb,
    0xdf, 0x30, 0x0, 0xc, 0xfb, 0x6f, 0xe8, 0x68,
    0xee, 0xfb, 0x4, 0xce, 0xfd, 0x84, 0xfb,

    /* U+0062 "b" */
    0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xe0, 0x7d, 0xfe, 0xc5, 0x0,
    0x1, 0xff, 0xcf, 0xec, 0xdf, 0xfb, 0x0, 0x1f,
    0xff, 0x60, 0x0, 0x3d, 0xf9, 0x1, 0xff, 0x70,
    0x0, 0x0, 0x2f, 0xf1, 0x1f, 0xf0, 0x0, 0x0,
    0x0, 0xbf, 0x51, 0xfe, 0x0, 0x0, 0x0, 0x9,
    0xf6, 0x1f, 0xf0, 0x0, 0x0, 0x0, 0xbf, 0x51,
    0xff, 0x70, 0x0, 0x0, 0x2f, 0xf1, 0x1f, 0xff,
    0x60, 0x0, 0x3d, 0xf9, 0x1, 0xfe, 0xcf, 0xec,
    0xdf, 0xfb, 0x0, 0x1f, 0xd0, 0x7d, 0xfe, 0xc6,
    0x0, 0x0,

    /* U+0063 "c" */
    0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x6f,
    0xfe, 0xcd, 0xff, 0x90, 0x3, 0xff, 0x60, 0x0,
    0x3d, 0xc1, 0xb, 0xf7, 0x0, 0x0, 0x1, 0x0,
    0xf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x1, 0x0,
    0x3, 0xff, 0x60, 0x0, 0x2d, 0xc1, 0x0, 0x5f,
    0xfe, 0xcd, 0xff, 0x90, 0x0, 0x2, 0x9d, 0xfe,
    0xb5, 0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf6, 0x0, 0x3, 0xae, 0xfe, 0x91, 0x9f,
    0x60, 0x7, 0xff, 0xec, 0xdf, 0xec, 0xf6, 0x4,
    0xff, 0x60, 0x0, 0x3d, 0xff, 0x60, 0xcf, 0x70,
    0x0, 0x0, 0x2f, 0xf6, 0xf, 0xf1, 0x0, 0x0,
    0x0, 0xbf, 0x61, 0xff, 0x0, 0x0, 0x0, 0x9,
    0xf6, 0xf, 0xf0, 0x0, 0x0, 0x0, 0xbf, 0x60,
    0xcf, 0x60, 0x0, 0x0, 0x1f, 0xf6, 0x4, 0xff,
    0x40, 0x0, 0x1c, 0xff, 0x60, 0x7, 0xff, 0xca,
    0xbf, 0xfc, 0xf6, 0x0, 0x3, 0xae, 0xfe, 0xa2,
    0x8f, 0x60,

    /* U+0065 "e" */
    0x0, 0x3, 0xae, 0xfe, 0x92, 0x0, 0x0, 0x6f,
    0xfd, 0xbd, 0xff, 0x40, 0x4, 0xff, 0x40, 0x0,
    0x5f, 0xf2, 0xb, 0xf5, 0x0, 0x0, 0x7, 0xf8,
    0xf, 0xf2, 0x11, 0x11, 0x13, 0xfd, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf, 0xf5, 0x44, 0x44,
    0x44, 0x44, 0xb, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x60, 0x0, 0x7, 0x80, 0x0, 0x6f,
    0xfe, 0xcc, 0xff, 0xd0, 0x0, 0x2, 0x9d, 0xff,
    0xc7, 0x0,

    /* U+0066 "f" */
    0x0, 0x5, 0xcf, 0xea, 0x0, 0x4, 0xff, 0xbb,
    0xb0, 0x0, 0xaf, 0x50, 0x0, 0x0, 0xc, 0xf2,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xf6, 0x6, 0xae,
    0xfb, 0xaa, 0x40, 0x0, 0xcf, 0x30, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0xcf, 0x30,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0xcf,
    0x30, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0,
    0xcf, 0x30, 0x0, 0x0,

    /* U+0067 "g" */
    0x0, 0x3, 0xae, 0xfe, 0xa2, 0x5f, 0x90, 0x6,
    0xff, 0xec, 0xdf, 0xfb, 0xf9, 0x4, 0xff, 0x60,
    0x0, 0x2c, 0xff, 0x90, 0xcf, 0x70, 0x0, 0x0,
    0xe, 0xf9, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0x91, 0xff, 0x0, 0x0, 0x0, 0x7, 0xf9, 0xf,
    0xf1, 0x0, 0x0, 0x0, 0x9f, 0x90, 0xbf, 0x70,
    0x0, 0x0, 0x1e, 0xf9, 0x4, 0xff, 0x60, 0x0,
    0x2c, 0xff, 0x90, 0x6, 0xff, 0xec, 0xcf, 0xfc,
    0xf8, 0x0, 0x3, 0xae, 0xfe, 0xa3, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf4, 0x0, 0xa5,
    0x0, 0x0, 0x7, 0xfe, 0x0, 0x3f, 0xff, 0xcb,
    0xce, 0xff, 0x30, 0x0, 0x17, 0xbe, 0xff, 0xd9,
    0x20, 0x0,

    /* U+0068 "h" */
    0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xe0, 0x7d, 0xff, 0xc4, 0x0, 0x1f, 0xfd,
    0xfe, 0xce, 0xff, 0x70, 0x1f, 0xfe, 0x40, 0x0,
    0x8f, 0xf1, 0x1f, 0xf5, 0x0, 0x0, 0xd, 0xf5,
    0x1f, 0xf0, 0x0, 0x0, 0x9, 0xf7, 0x1f, 0xe0,
    0x0, 0x0, 0x8, 0xf7, 0x1f, 0xe0, 0x0, 0x0,
    0x8, 0xf7, 0x1f, 0xe0, 0x0, 0x0, 0x8, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x8, 0xf7, 0x1f, 0xe0,
    0x0, 0x0, 0x8, 0xf7, 0x1f, 0xe0, 0x0, 0x0,
    0x8, 0xf7,

    /* U+0069 "i" */
    0x2e, 0xd1, 0x6f, 0xf3, 0x7, 0x60, 0x0, 0x0,
    0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0,
    0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0,
    0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0,

    /* U+006A "j" */
    0x0, 0x1, 0xde, 0x20, 0x0, 0x4f, 0xf5, 0x0,
    0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x3, 0xfd, 0x9, 0xdb, 0xff, 0x60, 0x8e,
    0xfd, 0x60, 0x0,

    /* U+006B "k" */
    0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x8f, 0xd1, 0x1f, 0xe0,
    0x0, 0xa, 0xfc, 0x10, 0x1f, 0xe0, 0x0, 0xbf,
    0xc1, 0x0, 0x1f, 0xe0, 0x1c, 0xfc, 0x0, 0x0,
    0x1f, 0xe2, 0xdf, 0xe0, 0x0, 0x0, 0x1f, 0xfe,
    0xff, 0xf8, 0x0, 0x0, 0x1f, 0xff, 0x84, 0xff,
    0x40, 0x0, 0x1f, 0xf7, 0x0, 0x7f, 0xf2, 0x0,
    0x1f, 0xe0, 0x0, 0xa, 0xfd, 0x0, 0x1f, 0xe0,
    0x0, 0x0, 0xcf, 0xb0, 0x1f, 0xe0, 0x0, 0x0,
    0x1e, 0xf7,

    /* U+006C "l" */
    0x1f, 0xe1, 0xfe, 0x1f, 0xe1, 0xfe, 0x1f, 0xe1,
    0xfe, 0x1f, 0xe1, 0xfe, 0x1f, 0xe1, 0xfe, 0x1f,
    0xe1, 0xfe, 0x1f, 0xe1, 0xfe, 0x1f, 0xe0,

    /* U+006D "m" */
    0x1f, 0xd1, 0x9d, 0xfe, 0xa3, 0x1, 0x8d, 0xff,
    0xb4, 0x0, 0x1f, 0xee, 0xfc, 0xbe, 0xff, 0x6e,
    0xfd, 0xbd, 0xff, 0x60, 0x1f, 0xfe, 0x20, 0x0,
    0xaf, 0xff, 0x50, 0x0, 0x7f, 0xe0, 0x1f, 0xf5,
    0x0, 0x0, 0x1f, 0xf8, 0x0, 0x0, 0xd, 0xf4,
    0x1f, 0xf0, 0x0, 0x0, 0xe, 0xf4, 0x0, 0x0,
    0xa, 0xf5, 0x1f, 0xe0, 0x0, 0x0, 0xd, 0xf2,
    0x0, 0x0, 0xa, 0xf6, 0x1f, 0xe0, 0x0, 0x0,
    0xd, 0xf2, 0x0, 0x0, 0xa, 0xf6, 0x1f, 0xe0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0xa, 0xf6,
    0x1f, 0xe0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0,
    0xa, 0xf6, 0x1f, 0xe0, 0x0, 0x0, 0xd, 0xf2,
    0x0, 0x0, 0xa, 0xf6, 0x1f, 0xe0, 0x0, 0x0,
    0xd, 0xf2, 0x0, 0x0, 0xa, 0xf6,

    /* U+006E "n" */
    0x1f, 0xd1, 0x8d, 0xff, 0xc4, 0x0, 0x1f, 0xee,
    0xfd, 0xbd, 0xff, 0x70, 0x1f, 0xfe, 0x30, 0x0,
    0x6f, 0xf1, 0x1f, 0xf5, 0x0, 0x0, 0xc, 0xf5,
    0x1f, 0xf0, 0x0, 0x0, 0x9, 0xf7, 0x1f, 0xe0,
    0x0, 0x0, 0x8, 0xf7, 0x1f, 0xe0, 0x0, 0x0,
    0x8, 0xf7, 0x1f, 0xe0, 0x0, 0x0, 0x8, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x8, 0xf7, 0x1f, 0xe0,
    0x0, 0x0, 0x8, 0xf7, 0x1f, 0xe0, 0x0, 0x0,
    0x8, 0xf7,

    /* U+006F "o" */
    0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x6,
    0xff, 0xec, 0xdf, 0xfa, 0x0, 0x3, 0xff, 0x60,
    0x0, 0x3d, 0xf8, 0x0, 0xbf, 0x70, 0x0, 0x0,
    0x2f, 0xf1, 0xf, 0xf1, 0x0, 0x0, 0x0, 0xbf,
    0x51, 0xff, 0x0, 0x0, 0x0, 0x9, 0xf6, 0xf,
    0xf1, 0x0, 0x0, 0x0, 0xbf, 0x50, 0xbf, 0x70,
    0x0, 0x0, 0x2f, 0xf1, 0x3, 0xff, 0x60, 0x0,
    0x3d, 0xf8, 0x0, 0x6, 0xff, 0xec, 0xdf, 0xfa,
    0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0, 0x0,

    /* U+0070 "p" */
    0x1f, 0xd0, 0x8d, 0xfe, 0xc5, 0x0, 0x1, 0xfe,
    0xdf, 0xda, 0xbf, 0xfb, 0x0, 0x1f, 0xff, 0x40,
    0x0, 0x1c, 0xf9, 0x1, 0xff, 0x60, 0x0, 0x0,
    0x1f, 0xf1, 0x1f, 0xf0, 0x0, 0x0, 0x0, 0xbf,
    0x51, 0xfe, 0x0, 0x0, 0x0, 0x9, 0xf6, 0x1f,
    0xf1, 0x0, 0x0, 0x0, 0xcf, 0x51, 0xff, 0x70,
    0x0, 0x0, 0x2f, 0xf1, 0x1f, 0xff, 0x60, 0x0,
    0x3d, 0xf9, 0x1, 0xff, 0xbf, 0xec, 0xdf, 0xfb,
    0x0, 0x1f, 0xe0, 0x7d, 0xfe, 0xc6, 0x0, 0x1,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x3, 0xae, 0xfe, 0x92, 0x8f, 0x60, 0x7,
    0xff, 0xec, 0xdf, 0xfb, 0xf6, 0x4, 0xff, 0x60,
    0x0, 0x3d, 0xff, 0x60, 0xcf, 0x70, 0x0, 0x0,
    0x2f, 0xf6, 0xf, 0xf1, 0x0, 0x0, 0x0, 0xbf,
    0x61, 0xff, 0x0, 0x0, 0x0, 0x9, 0xf6, 0xf,
    0xf1, 0x0, 0x0, 0x0, 0xbf, 0x60, 0xcf, 0x70,
    0x0, 0x0, 0x2f, 0xf6, 0x4, 0xff, 0x60, 0x0,
    0x3d, 0xff, 0x60, 0x7, 0xff, 0xec, 0xdf, 0xec,
    0xf6, 0x0, 0x3, 0xae, 0xfe, 0x91, 0x9f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x60,

    /* U+0072 "r" */
    0x1f, 0xd0, 0x8d, 0xd1, 0xfd, 0xcf, 0xfd, 0x1f,
    0xff, 0x60, 0x1, 0xff, 0x70, 0x0, 0x1f, 0xf1,
    0x0, 0x1, 0xff, 0x0, 0x0, 0x1f, 0xe0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x1,
    0xfe, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0,

    /* U+0073 "s" */
    0x0, 0x4b, 0xef, 0xec, 0x71, 0x8, 0xff, 0xcb,
    0xdf, 0xf4, 0xf, 0xf3, 0x0, 0x1, 0x50, 0x1f,
    0xe0, 0x0, 0x0, 0x0, 0xc, 0xfd, 0x74, 0x10,
    0x0, 0x1, 0xbf, 0xff, 0xfd, 0x70, 0x0, 0x0,
    0x46, 0xaf, 0xf8, 0x0, 0x0, 0x0, 0x3, 0xfd,
    0x9, 0x30, 0x0, 0x6, 0xfc, 0x4f, 0xfe, 0xcb,
    0xdf, 0xf4, 0x4, 0xad, 0xff, 0xd9, 0x20,

    /* U+0074 "t" */
    0x0, 0x68, 0x10, 0x0, 0x0, 0xc, 0xf3, 0x0,
    0x0, 0x0, 0xcf, 0x30, 0x0, 0xb, 0xff, 0xff,
    0xff, 0x60, 0x6a, 0xef, 0xba, 0xa4, 0x0, 0xc,
    0xf3, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0xcf, 0x30,
    0x0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0x0, 0x4f,
    0xfc, 0xcd, 0x0, 0x0, 0x5c, 0xfe, 0x90,

    /* U+0075 "u" */
    0x3f, 0xd0, 0x0, 0x0, 0xb, 0xf4, 0x3f, 0xd0,
    0x0, 0x0, 0xb, 0xf4, 0x3f, 0xd0, 0x0, 0x0,
    0xb, 0xf4, 0x3f, 0xd0, 0x0, 0x0, 0xb, 0xf4,
    0x3f, 0xd0, 0x0, 0x0, 0xb, 0xf4, 0x3f, 0xd0,
    0x0, 0x0, 0xb, 0xf4, 0x2f, 0xe0, 0x0, 0x0,
    0xd, 0xf4, 0x1f, 0xf1, 0x0, 0x0, 0x2f, 0xf4,
    0xc, 0xfa, 0x0, 0x1, 0xcf, 0xf4, 0x3, 0xff,
    0xeb, 0xcf, 0xfd, 0xf4, 0x0, 0x2a, 0xef, 0xea,
    0x2a, 0xf4,

    /* U+0076 "v" */
    0xd, 0xf4, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x6f,
    0xb0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0xef, 0x20,
    0x0, 0x5, 0xfa, 0x0, 0x7, 0xf9, 0x0, 0x0,
    0xcf, 0x30, 0x0, 0x1f, 0xf0, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0x9f, 0x60, 0xa, 0xf5, 0x0, 0x0,
    0x2, 0xfd, 0x1, 0xfd, 0x0, 0x0, 0x0, 0xb,
    0xf4, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x4f, 0xce,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x20, 0x0, 0x0,

    /* U+0077 "w" */
    0xbf, 0x30, 0x0, 0x0, 0x9f, 0x80, 0x0, 0x0,
    0x3f, 0x85, 0xf9, 0x0, 0x0, 0xe, 0xfe, 0x0,
    0x0, 0x9, 0xf2, 0xe, 0xe0, 0x0, 0x5, 0xff,
    0xf4, 0x0, 0x0, 0xfc, 0x0, 0x8f, 0x50, 0x0,
    0xbf, 0x5f, 0xa0, 0x0, 0x5f, 0x60, 0x2, 0xfb,
    0x0, 0x1f, 0xb0, 0xdf, 0x0, 0xc, 0xf1, 0x0,
    0xc, 0xf1, 0x7, 0xf5, 0x7, 0xf6, 0x2, 0xfa,
    0x0, 0x0, 0x6f, 0x60, 0xde, 0x0, 0x1f, 0xc0,
    0x8f, 0x40, 0x0, 0x1, 0xfc, 0x4f, 0x80, 0x0,
    0xbf, 0x2e, 0xe0, 0x0, 0x0, 0xa, 0xfc, 0xf2,
    0x0, 0x4, 0xfc, 0xf8, 0x0, 0x0, 0x0, 0x4f,
    0xfc, 0x0, 0x0, 0xe, 0xff, 0x20, 0x0, 0x0,
    0x0, 0xef, 0x60, 0x0, 0x0, 0x8f, 0xc0, 0x0,
    0x0,

    /* U+0078 "x" */
    0x2f, 0xf2, 0x0, 0x0, 0x8f, 0xa0, 0x5, 0xfd,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x8f, 0xa0, 0x2e,
    0xf2, 0x0, 0x0, 0xc, 0xf7, 0xcf, 0x50, 0x0,
    0x0, 0x1, 0xef, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf1, 0x0, 0x0, 0x0, 0x3, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x1e, 0xf4, 0xaf, 0x80, 0x0,
    0x0, 0xbf, 0x70, 0xd, 0xf5, 0x0, 0x8, 0xfb,
    0x0, 0x2, 0xff, 0x20, 0x5f, 0xd1, 0x0, 0x0,
    0x5f, 0xd0,

    /* U+0079 "y" */
    0xd, 0xf4, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x5f,
    0xb0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0xef, 0x20,
    0x0, 0x5, 0xfa, 0x0, 0x7, 0xf9, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0xf, 0xf1, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x8f, 0x80, 0xa, 0xf4, 0x0, 0x0,
    0x1, 0xfe, 0x1, 0xfd, 0x0, 0x0, 0x0, 0xa,
    0xf6, 0x8f, 0x60, 0x0, 0x0, 0x0, 0x3f, 0xde,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x90, 0x0, 0x0, 0x3, 0x0,
    0x1e, 0xf1, 0x0, 0x0, 0x3, 0xfd, 0xbf, 0xf7,
    0x0, 0x0, 0x0, 0x8, 0xef, 0xd6, 0x0, 0x0,
    0x0, 0x0,

    /* U+007A "z" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0x0, 0xaa, 0xaa,
    0xaa, 0xef, 0xc0, 0x0, 0x0, 0x0, 0x4f, 0xe1,
    0x0, 0x0, 0x0, 0x2f, 0xf3, 0x0, 0x0, 0x0,
    0x1d, 0xf6, 0x0, 0x0, 0x0, 0xb, 0xf9, 0x0,
    0x0, 0x0, 0x8, 0xfb, 0x0, 0x0, 0x0, 0x5,
    0xfd, 0x10, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0,
    0x0, 0x0, 0xef, 0xda, 0xaa, 0xaa, 0xa1, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0x20,

    /* U+007B "{" */
    0x0, 0x2b, 0xef, 0x0, 0xcf, 0xd9, 0x1, 0xff,
    0x10, 0x2, 0xfe, 0x0, 0x2, 0xfe, 0x0, 0x2,
    0xfe, 0x0, 0x2, 0xfe, 0x0, 0x2, 0xfd, 0x0,
    0x8d, 0xf9, 0x0, 0xcf, 0xf4, 0x0, 0x4, 0xfd,
    0x0, 0x2, 0xfe, 0x0, 0x2, 0xfe, 0x0, 0x2,
    0xfe, 0x0, 0x2, 0xfe, 0x0, 0x1, 0xfe, 0x0,
    0x0, 0xff, 0x10, 0x0, 0xcf, 0xd9, 0x0, 0x1a,
    0xef,

    /* U+007C "|" */
    0xcf, 0x1c, 0xf1, 0xcf, 0x1c, 0xf1, 0xcf, 0x1c,
    0xf1, 0xcf, 0x1c, 0xf1, 0xcf, 0x1c, 0xf1, 0xcf,
    0x1c, 0xf1, 0xcf, 0x1c, 0xf1, 0xcf, 0x1c, 0xf1,
    0xcf, 0x1c, 0xf1, 0xcf, 0x10,

    /* U+007D "}" */
    0x9f, 0xd5, 0x0, 0x5, 0xbf, 0xf3, 0x0, 0x0,
    0xaf, 0x70, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x8f,
    0x80, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x8f, 0x80,
    0x0, 0x7, 0xf9, 0x0, 0x0, 0x3f, 0xfa, 0x10,
    0x1, 0xdf, 0xf2, 0x0, 0x6f, 0xa0, 0x0, 0x7,
    0xf8, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x8, 0xf8,
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x8, 0xf8, 0x0,
    0x0, 0xaf, 0x60, 0x5, 0xbf, 0xf2, 0x0, 0x9f,
    0xd5, 0x0, 0x0,

    /* U+007E "~" */
    0x8, 0xee, 0x90, 0x0, 0x6e, 0x5f, 0xba, 0xfd,
    0x42, 0xdb, 0xab, 0x0, 0x2c, 0xff, 0xe2, 0x32,
    0x0, 0x0, 0x23, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x38, 0xdf, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x15, 0xae, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x7c, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x49,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xdf, 0xf0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xb6, 0x10, 0x9f, 0xf0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xd9, 0x40, 0x0,
    0x0, 0x9f, 0xf0, 0x0, 0x0, 0xb, 0xff, 0x72,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0x0, 0x0,
    0xb, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xf0, 0x0, 0x0, 0xb, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xf0, 0x0, 0x0, 0xb, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0x0,
    0x0, 0xb, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf0, 0x0, 0x0, 0xb, 0xfe, 0x0, 0x0,
    0x0, 0x5c, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb,
    0xfe, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x25, 0x5c, 0xfe, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xf0, 0x2c, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xc0, 0xcf, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfa,
    0x10, 0xef, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x22, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xac, 0xc9, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F008 "" */
    0x83, 0x0, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xc0, 0x3, 0x8f, 0xa7, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x87, 0xaf, 0xff, 0xee, 0xff,
    0x33, 0x33, 0x33, 0x33, 0x3f, 0xfe, 0xef, 0xff,
    0x50, 0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x5f, 0xf5, 0x1, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x5, 0xff, 0xb8, 0x9f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x98, 0xbf, 0xfe,
    0xdd, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfd,
    0xde, 0xff, 0x50, 0x1f, 0xfe, 0xdd, 0xdd, 0xdd,
    0xde, 0xff, 0x10, 0x5f, 0xf5, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x5, 0xff, 0xc9,
    0xaf, 0xf2, 0x11, 0x11, 0x11, 0x12, 0xff, 0xa9,
    0xcf, 0xfe, 0xcd, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xfd, 0xce, 0xff, 0x50, 0x1f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x5f, 0xf5, 0x1,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x5,
    0xff, 0xca, 0xbf, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xba, 0xcf, 0xfd, 0xbc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xbd, 0xfc, 0x50, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x5c,

    /* U+F00B "" */
    0x1, 0x11, 0x10, 0x0, 0x1, 0x11, 0x11, 0x11,
    0x11, 0x11, 0xd, 0xff, 0xff, 0xe0, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0x19, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x19, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xf0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x13,
    0x33, 0x31, 0x0, 0x23, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x12, 0x44, 0x44, 0x20, 0x4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x42, 0xef, 0xff, 0xff, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff,
    0xff, 0xf1, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x19, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff,
    0xfc, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xfc, 0x5, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff,
    0xf1, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x19, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0x18, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x44, 0x44, 0x20, 0x4, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x42,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xfc, 0x0, 0x6, 0x10, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xfb, 0x0, 0xc,
    0xfd, 0x10, 0x0, 0x0, 0x3, 0xff, 0xff, 0xfb,
    0x0, 0xc, 0xff, 0xfd, 0x10, 0x0, 0x3, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0xdf, 0xff, 0xfd, 0x10,
    0x3, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xfd, 0x13, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xfd, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xda, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0x50, 0x0, 0x0, 0x1, 0xcf, 0x60, 0xcf,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xff, 0x3e, 0xff,
    0xff, 0x50, 0x1, 0xdf, 0xff, 0xf5, 0x3e, 0xff,
    0xff, 0x51, 0xdf, 0xff, 0xf9, 0x0, 0x3f, 0xff,
    0xff, 0xdf, 0xff, 0xf9, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x1, 0xdf, 0xff, 0xf9, 0x3f, 0xff,
    0xff, 0x50, 0xcf, 0xff, 0xf9, 0x0, 0x3f, 0xff,
    0xff, 0x3e, 0xff, 0xf9, 0x0, 0x0, 0x3f, 0xff,
    0xf5, 0x3f, 0xf9, 0x0, 0x0, 0x0, 0x3e, 0xfa,
    0x0, 0x24, 0x0, 0x0, 0x0, 0x0, 0x14, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22,
    0x0, 0x3f, 0xff, 0x0, 0x3, 0x10, 0x0, 0x0,
    0x0, 0x5f, 0xf2, 0x3, 0xff, 0xf0, 0x4, 0xfe,
    0x20, 0x0, 0x0, 0x4f, 0xff, 0x90, 0x3f, 0xff,
    0x0, 0xcf, 0xfe, 0x20, 0x0, 0x1f, 0xff, 0xf5,
    0x3, 0xff, 0xf0, 0x8, 0xff, 0xfc, 0x0, 0xa,
    0xff, 0xf5, 0x0, 0x3f, 0xff, 0x0, 0x8, 0xff,
    0xf6, 0x1, 0xff, 0xf9, 0x0, 0x3, 0xff, 0xf0,
    0x0, 0xc, 0xff, 0xe0, 0x6f, 0xff, 0x10, 0x0,
    0x3f, 0xff, 0x0, 0x0, 0x4f, 0xff, 0x39, 0xff,
    0xb0, 0x0, 0x3, 0xff, 0xf0, 0x0, 0x0, 0xef,
    0xf6, 0xbf, 0xf9, 0x0, 0x0, 0x3f, 0xff, 0x0,
    0x0, 0xc, 0xff, 0x8b, 0xff, 0x80, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0xbf, 0xf8, 0xaf, 0xfa,
    0x0, 0x0, 0x9, 0xa7, 0x0, 0x0, 0xd, 0xff,
    0x77, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xf4, 0x2f, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0x0, 0xcf, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x90,
    0x3, 0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xf1, 0x0, 0x6, 0xff, 0xff, 0xa4, 0x10,
    0x15, 0xbf, 0xff, 0xf4, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x8d, 0xff, 0xff,
    0xfc, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x34, 0x31, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xef,
    0xec, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x3d, 0x51, 0xaf, 0xff, 0xff,
    0xff, 0xa1, 0x6d, 0x30, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x1e, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x9f, 0xff, 0xff, 0xfe, 0x10, 0x9,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0xbf, 0xff, 0xf9,
    0x0, 0x0, 0x5f, 0xff, 0xf5, 0x0, 0x0, 0x5,
    0xff, 0xff, 0x50, 0x0, 0x5, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x4f, 0xff, 0xf5, 0x0, 0x0, 0x6f,
    0xff, 0xf9, 0x0, 0x0, 0x9, 0xff, 0xff, 0x60,
    0x0, 0xbf, 0xff, 0xff, 0xf5, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xb1, 0x1f, 0xff, 0xff, 0xff, 0xfc,
    0xac, 0xff, 0xff, 0xff, 0xff, 0x10, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x5, 0xfa, 0x4d, 0xff, 0xff,
    0xff, 0xfd, 0x49, 0xf5, 0x0, 0x0, 0x1, 0x0,
    0x6, 0xff, 0xff, 0xf6, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x24, 0x31, 0x0, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xe4, 0x0, 0x3f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0xff, 0x60,
    0x4f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xff, 0xff, 0xf9, 0x4f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xc1, 0x5f, 0xff,
    0xef, 0xff, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xfa, 0x3, 0x12, 0xef, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0x70, 0x7f, 0xe3, 0x1c,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xf4,
    0xa, 0xff, 0xff, 0x50, 0x9f, 0xff, 0x70, 0x0,
    0x3, 0xef, 0xfd, 0x21, 0xcf, 0xff, 0xff, 0xf8,
    0x7, 0xff, 0xfa, 0x0, 0x5f, 0xff, 0xc1, 0x3e,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x4e, 0xff, 0xd2,
    0xdf, 0xf9, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x22, 0xdf, 0xf7, 0x3f, 0x60, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x1b, 0xc0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xfe, 0x11, 0x15, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xfd, 0x0, 0x3, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xfd, 0x0, 0x3, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xfd, 0x0, 0x3, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xfd, 0x0, 0x3, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x35, 0x55,
    0x52, 0x0, 0x0, 0x45, 0x55, 0x51, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x46, 0x66, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x2, 0x88, 0x89,
    0xff, 0xff, 0xf9, 0x88, 0x82, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0x60, 0xbf, 0xb0, 0x6f, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x50, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x3f,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb9, 0xf7, 0xdf, 0xf9, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9,

    /* U+F01C "" */
    0x0, 0x0, 0x6, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0x30, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xd, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x80, 0x0,
    0x0, 0x8f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xef, 0xf3, 0x0, 0x3, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xfd, 0x0,
    0xd, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0x80, 0x8f, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xf3,
    0xff, 0xfe, 0xee, 0xee, 0x50, 0x0, 0x0, 0xb,
    0xee, 0xee, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x44, 0x44, 0xcf,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x46, 0x50, 0x0, 0x0, 0x3, 0x9d, 0xff,
    0xfc, 0x71, 0x0, 0xe, 0xff, 0x0, 0x0, 0x1b,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x10, 0xdf, 0xf0,
    0x0, 0x3e, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfe,
    0x3c, 0xff, 0x0, 0x3f, 0xff, 0xfa, 0x30, 0x0,
    0x4b, 0xff, 0xff, 0xef, 0xf0, 0x1e, 0xff, 0xe3,
    0x0, 0x0, 0x0, 0x4, 0xef, 0xff, 0xff, 0x8,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x10, 0x2, 0xef,
    0xff, 0xf0, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xfc, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xdd,
    0x50, 0x0, 0x0, 0x0, 0x1c, 0xdd, 0xdd, 0xdd,
    0xdb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbc, 0xcc,
    0xcc, 0xcc, 0xc1, 0x0, 0x0, 0x0, 0x5, 0xcc,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0xcf, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xf, 0xff, 0xfe,
    0x10, 0x11, 0x0, 0x0, 0x0, 0x1e, 0xff, 0x80,
    0xff, 0xff, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xe1, 0xf, 0xfe, 0xff, 0xff, 0x93, 0x0,
    0x2, 0x9f, 0xff, 0xf4, 0x0, 0xff, 0xc4, 0xff,
    0xff, 0xff, 0xde, 0xff, 0xff, 0xf4, 0x0, 0xf,
    0xfd, 0x1, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xc2,
    0x0, 0x0, 0xff, 0xe0, 0x0, 0x39, 0xef, 0xff,
    0xea, 0x40, 0x0, 0x0, 0x5, 0x64, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x3b, 0x20, 0x0, 0x0,
    0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x80, 0x0, 0x0, 0x3f, 0xff, 0xf8, 0x9d, 0xdd,
    0xdf, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8d, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x6, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x6, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x80, 0x0, 0x0, 0x0, 0x6, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x3b, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x9d, 0xdd, 0xdf, 0xff, 0xff, 0x80, 0x1, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6f, 0x70,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4f, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x7, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1d, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x8f, 0xc0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6e, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3b, 0x20, 0x0, 0x0,
    0x3, 0xef, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0x70, 0x0, 0x5, 0x10, 0x1d, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x80, 0x0, 0x3f,
    0xe4, 0x3, 0xff, 0x30, 0x0, 0x0, 0x3, 0xff,
    0xff, 0x80, 0x0, 0xa, 0xff, 0x20, 0x7f, 0xb0,
    0x9d, 0xdd, 0xdf, 0xff, 0xff, 0x80, 0x1, 0x0,
    0x9f, 0xc0, 0xe, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x7f, 0x80, 0xd, 0xf3, 0x9, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4f, 0xf4,
    0x7, 0xf8, 0x6, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x6, 0xfa, 0x4, 0xfa, 0x4, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x5, 0xfb,
    0x4, 0xfa, 0x4, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x2d, 0xf6, 0x6, 0xf9, 0x5, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x8f, 0xc0,
    0xc, 0xf5, 0x9, 0xf7, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x5, 0x0, 0x6f, 0xe0, 0xd, 0xf3,
    0x0, 0x0, 0x6, 0xff, 0xff, 0x80, 0x0, 0x6,
    0xff, 0x40, 0x5f, 0xd0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0x80, 0x0, 0x3f, 0xf7, 0x0, 0xef, 0x60,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x80, 0x0, 0x9,
    0x40, 0xb, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6e, 0x40, 0x0, 0x0, 0x0, 0xaf, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F03E "" */
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfb, 0x69,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x0, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xb2, 0xdf, 0xff, 0xff, 0xff,
    0xe3, 0x1, 0xdf, 0xff, 0xff, 0xb0, 0x1, 0xdf,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xf9, 0xbf,
    0xff, 0xb0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xf8, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xad, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F043 "" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xfe, 0x10, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x6e, 0xfb, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xaf, 0xf1, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x14,
    0xff, 0xc0, 0x5b, 0xff, 0xff, 0xff, 0xb0, 0xb,
    0xff, 0xd5, 0x14, 0xff, 0xff, 0xf2, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x1,
    0x69, 0x98, 0x30, 0x0, 0x0,

    /* U+F048 "" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xfc, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x2f, 0xfc,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0x2f, 0xfc, 0x0,
    0x0, 0x9, 0xff, 0xff, 0x2f, 0xfc, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0x2f, 0xfc, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x2f, 0xfc, 0x1, 0xcf, 0xff, 0xff,
    0xff, 0x2f, 0xfc, 0x1d, 0xff, 0xff, 0xff, 0xff,
    0x2f, 0xfe, 0xef, 0xff, 0xff, 0xff, 0xff, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x2f, 0xfc, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0x2f, 0xfc, 0x3, 0xff, 0xff,
    0xff, 0xff, 0x2f, 0xfc, 0x0, 0x2e, 0xff, 0xff,
    0xff, 0x2f, 0xfc, 0x0, 0x2, 0xdf, 0xff, 0xff,
    0x2f, 0xfc, 0x0, 0x0, 0x1d, 0xff, 0xff, 0x2f,
    0xfc, 0x0, 0x0, 0x1, 0xcf, 0xff, 0x2f, 0xfc,
    0x0, 0x0, 0x0, 0xb, 0xfc, 0x4, 0x53, 0x0,
    0x0, 0x0, 0x0, 0x41,

    /* U+F04B "" */
    0x4, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xc3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf9, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xfe,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xc3, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd4, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x10, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe5, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xd4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfe,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x88, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F04C "" */
    0x0, 0x11, 0x11, 0x0, 0x0, 0x0, 0x11, 0x11,
    0x0, 0x6, 0xff, 0xff, 0xff, 0x40, 0x2, 0xef,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xfc, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0xe0, 0xb, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0xbf, 0xff, 0xff, 0xff, 0x2f,
    0xff, 0xff, 0xff, 0xe0, 0xb, 0xff, 0xff, 0xff,
    0xf2, 0xff, 0xff, 0xff, 0xfe, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0x2f, 0xff, 0xff, 0xff, 0xe0, 0xb,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0x2f, 0xff, 0xff,
    0xff, 0xe0, 0xb, 0xff, 0xff, 0xff, 0xf2, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0x2f, 0xff, 0xff, 0xff, 0xe0, 0xb, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0xff, 0xff, 0xfe, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0x2f, 0xff, 0xff, 0xff, 0xe0,
    0xb, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xbf, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xff, 0xff, 0xe0, 0xb, 0xff, 0xff, 0xff, 0xf2,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x2f, 0xff, 0xff, 0xff, 0xd0, 0xa, 0xff,
    0xff, 0xff, 0xf1, 0x8f, 0xff, 0xff, 0xf6, 0x0,
    0x4f, 0xff, 0xff, 0xfa, 0x0, 0x24, 0x44, 0x42,
    0x0, 0x0, 0x14, 0x44, 0x43, 0x0,

    /* U+F04D "" */
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x35, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x54, 0x0,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xd,
    0xe4, 0x0, 0x0, 0x0, 0xf, 0xfd, 0x3f, 0xff,
    0x40, 0x0, 0x0, 0x1f, 0xfe, 0x4f, 0xff, 0xf6,
    0x0, 0x0, 0x1f, 0xfe, 0x4f, 0xff, 0xff, 0x70,
    0x0, 0x1f, 0xfe, 0x4f, 0xff, 0xff, 0xf8, 0x0,
    0x1f, 0xfe, 0x4f, 0xff, 0xff, 0xff, 0x90, 0x1f,
    0xfe, 0x4f, 0xff, 0xff, 0xff, 0xfa, 0x1f, 0xfe,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xfe, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xfe, 0x4f, 0xff, 0xff, 0xff,
    0xfd, 0x2f, 0xfe, 0x4f, 0xff, 0xff, 0xff, 0xc1,
    0x1f, 0xfe, 0x4f, 0xff, 0xff, 0xfb, 0x0, 0x1f,
    0xfe, 0x4f, 0xff, 0xff, 0xa0, 0x0, 0x1f, 0xfe,
    0x4f, 0xff, 0xf9, 0x0, 0x0, 0x1f, 0xfe, 0x4f,
    0xff, 0x80, 0x0, 0x0, 0x1f, 0xfe, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x1f, 0xfd, 0x2, 0x30, 0x0,
    0x0, 0x0, 0x4, 0x53,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x10, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x2, 0xac, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x1, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x8a, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xb0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xd0, 0x0, 0x0, 0xa, 0xff, 0xfe, 0x10,
    0x0, 0x0, 0xaf, 0xff, 0xe1, 0x0, 0x0, 0xa,
    0xff, 0xfe, 0x10, 0x0, 0x0, 0xaf, 0xff, 0xe1,
    0x0, 0x0, 0xa, 0xff, 0xfe, 0x10, 0x0, 0x0,
    0x9f, 0xff, 0xe1, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x1, 0xce, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F054 "" */
    0x9, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x1c,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x1, 0xcf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xd0, 0x0, 0x0, 0x9, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x9f, 0xff, 0xe2, 0x0,
    0x0, 0x9, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x9f,
    0xff, 0xe2, 0x0, 0x0, 0x9, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x9f, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0xbf, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x1d, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x7d, 0xdd, 0xdd, 0xdf,
    0xff, 0xfd, 0xdd, 0xdd, 0xdb, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x5b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe2, 0x1, 0x11, 0x11, 0x1c, 0xff, 0xf3,
    0x11, 0x11, 0x10, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x41, 0x0, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x8e, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xec, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x5a, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x1, 0x69, 0xbc, 0xcb, 0x84,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xfa, 0x42, 0x36, 0xcf,
    0xff, 0xe4, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfe,
    0x30, 0x0, 0x0, 0x6, 0xff, 0xff, 0x60, 0x0,
    0x0, 0xcf, 0xff, 0xf2, 0x0, 0xb, 0xb6, 0x0,
    0x7f, 0xff, 0xf7, 0x0, 0x9, 0xff, 0xff, 0x70,
    0x0, 0xe, 0xff, 0xb0, 0xd, 0xff, 0xff, 0x40,
    0x4f, 0xff, 0xff, 0x20, 0x0, 0x2f, 0xff, 0xf6,
    0x7, 0xff, 0xff, 0xe0, 0xdf, 0xff, 0xff, 0x0,
    0xb9, 0xff, 0xff, 0xfa, 0x4, 0xff, 0xff, 0xf8,
    0xef, 0xff, 0xff, 0x1, 0xff, 0xff, 0xff, 0xfb,
    0x4, 0xff, 0xff, 0xf9, 0x5f, 0xff, 0xff, 0x10,
    0xdf, 0xff, 0xff, 0xf7, 0x6, 0xff, 0xff, 0xf1,
    0xb, 0xff, 0xff, 0x60, 0x4f, 0xff, 0xff, 0xd0,
    0xc, 0xff, 0xff, 0x60, 0x1, 0xdf, 0xff, 0xe1,
    0x4, 0xcf, 0xfa, 0x10, 0x5f, 0xff, 0xf9, 0x0,
    0x0, 0x1d, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x4,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xe7, 0x20, 0x3, 0x9f, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x8c, 0xef, 0xfe, 0xb7, 0x10, 0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xbf, 0xff, 0x70, 0x0, 0x37, 0xac, 0xcb,
    0x95, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xb7, 0xef, 0xff, 0xff, 0xff, 0xff, 0x91,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff, 0xff,
    0xfd, 0x73, 0x25, 0xaf, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xf9, 0x8, 0xc8, 0x10, 0x3f,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x35, 0x0, 0x6,
    0xff, 0xfc, 0xaf, 0xfe, 0x10, 0x9f, 0xff, 0xf8,
    0x0, 0x0, 0xe, 0xf8, 0x0, 0x3, 0xef, 0xff,
    0xff, 0xfb, 0x3, 0xff, 0xff, 0xf3, 0x0, 0x8,
    0xff, 0xfc, 0x10, 0x1, 0xbf, 0xff, 0xff, 0xf0,
    0xf, 0xff, 0xff, 0xc0, 0x0, 0x9f, 0xff, 0xfe,
    0x20, 0x0, 0x8f, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xfd, 0x0, 0x2, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x4e, 0xff, 0xf2, 0x2f, 0xff, 0xff, 0x50, 0x0,
    0x7, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x1c, 0xff,
    0xfc, 0xff, 0xff, 0xa0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0x93, 0x0, 0x0,
    0x2, 0xdf, 0xfe, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xbf, 0xff, 0xff, 0xfc, 0x20, 0x1, 0xbf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0xbe, 0xff, 0xea, 0x0, 0x0, 0x7f, 0xff, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4e, 0xff, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1c, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x30,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xff, 0xf1, 0x0, 0x7f, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x10, 0x7,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xff, 0xf2, 0x0, 0x8f, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0x30,
    0x9, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xf4, 0x0, 0xaf, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0x50, 0xb, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xfd, 0xbb, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0x91, 0x3e, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x13,
    0xef, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x18,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0x60,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x90, 0x4,
    0x55, 0x55, 0x10, 0x0, 0x0, 0x0, 0x45, 0x7f,
    0xff, 0x90, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfe, 0xef,
    0xff, 0xff, 0xfd, 0x10, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x9, 0xff, 0xb0, 0x6f, 0xff,
    0xd1, 0x4f, 0xff, 0x40, 0x0, 0x0, 0xa, 0xc0,
    0x5f, 0xff, 0xe1, 0x3, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x1, 0x4f, 0xff, 0xe2, 0x0, 0x7, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xf4, 0x16, 0x0, 0x1e, 0x90, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xf5, 0xc, 0xf6, 0x4, 0xff, 0xa0,
    0x5, 0x66, 0x6d, 0xff, 0xf6, 0xa, 0xff, 0xf7,
    0x8f, 0xff, 0xa0, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xfe,
    0xde, 0xee, 0xe9, 0x0, 0x0, 0x0, 0x4e, 0xee,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0x30, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x13, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xf9, 0x4f, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xf9, 0x0, 0x4f, 0xff,
    0xf6, 0x0, 0x0, 0x2e, 0xff, 0xf9, 0x0, 0x0,
    0x4f, 0xff, 0xf6, 0x0, 0x2e, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xf6, 0xa, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf1, 0x4f,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xfa,
    0x0, 0x36, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x36, 0x0,

    /* U+F078 "" */
    0x1, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x30, 0x2, 0xef, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xef, 0x60, 0xbf, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xff, 0x14, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x1, 0xef, 0xff, 0x90, 0x4, 0xff,
    0xff, 0x60, 0x0, 0x1, 0xef, 0xff, 0xa0, 0x0,
    0x4, 0xff, 0xff, 0x60, 0x1, 0xef, 0xff, 0xa0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0x61, 0xef, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xef,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x70, 0x0, 0x0,
    0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x8c, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xfe, 0x20, 0x1, 0x89, 0x99, 0x99, 0x99, 0x99,
    0x81, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xfe, 0x20,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xfe, 0x30, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x9f, 0xfd,
    0xff, 0xdf, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x2,
    0xff, 0x80, 0x0, 0xb, 0xfe, 0x2f, 0xf9, 0x7f,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf8, 0x0,
    0x0, 0x17, 0x21, 0xff, 0x90, 0x65, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x1, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x1f, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x61, 0x1f, 0xf8, 0x4, 0x30, 0x0,
    0x1, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xc2, 0xff, 0x86, 0xff, 0x20, 0x0, 0x1f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xdf, 0xfd,
    0xff, 0xf2, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0xb, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0xb, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x8a,
    0xaa, 0xaa, 0xaa, 0xaa, 0xa6, 0x0, 0xa, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xe3, 0x0, 0x0,

    /* U+F07B "" */
    0x2a, 0xcc, 0xcc, 0xcc, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb2, 0x22, 0x22, 0x22, 0x20, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x1, 0x77, 0x78,
    0xff, 0xff, 0xf8, 0x77, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xf9, 0x1f, 0xff, 0xff, 0x19, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xd0, 0x57, 0x77, 0x50, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x11,
    0x12, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x3f,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb9, 0xf7, 0xdf, 0xf9, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x43, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xfb, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x3, 0x82, 0x0, 0x0, 0xa, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x5, 0xcf, 0xfd, 0x10, 0x1,
    0xbf, 0xff, 0xfc, 0x0, 0x0, 0x6, 0xef, 0xff,
    0xff, 0xb0, 0x6e, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xd8, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x69, 0x87, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3c, 0xff, 0xb2, 0x0, 0x0, 0x0,
    0x2, 0x54, 0x0, 0x3f, 0xff, 0xff, 0xe1, 0x0,
    0x0, 0x7, 0xff, 0xfe, 0x2b, 0xff, 0xbc, 0xff,
    0x90, 0x0, 0x7, 0xff, 0xff, 0xe1, 0xff, 0xb0,
    0xd, 0xfd, 0x0, 0x7, 0xff, 0xff, 0xd2, 0xf,
    0xfd, 0x0, 0xef, 0xc0, 0x8, 0xff, 0xff, 0xd1,
    0x0, 0xaf, 0xfe, 0xef, 0xfc, 0x8, 0xff, 0xff,
    0xd1, 0x0, 0x1, 0xef, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x1, 0x9d, 0xef, 0xff,
    0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0x4, 0x8a, 0xff, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x10, 0x0, 0x8, 0xff, 0xff, 0xff, 0xe2,
    0xbf, 0xff, 0xfd, 0x10, 0x0, 0xef, 0xe3, 0x4f,
    0xfb, 0x0, 0xbf, 0xff, 0xfd, 0x10, 0xf, 0xfb,
    0x0, 0xdf, 0xd0, 0x0, 0xaf, 0xff, 0xfd, 0x10,
    0xcf, 0xf9, 0xaf, 0xfa, 0x0, 0x0, 0xaf, 0xff,
    0xfd, 0x14, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0,
    0x8f, 0xff, 0xe2, 0x4, 0xdf, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x36, 0x61, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0x22, 0x22, 0x22, 0x20, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0x1c, 0x80, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf1, 0xcf, 0x80, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0x1c, 0xff, 0x80, 0x37, 0x76,
    0xc, 0xff, 0xff, 0xff, 0xf1, 0x9c, 0xcc, 0x1f,
    0xff, 0xf0, 0xcf, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0xff, 0xff, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x2f, 0xff, 0xf0, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff, 0xf0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xff,
    0xff, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x2f, 0xff, 0xf0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0xff, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x2f, 0xff, 0xf0, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xf0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xff, 0xff, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x2f, 0xff, 0xf2, 0x6c, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xa0, 0xff, 0xff, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x6,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa7, 0x0, 0x0,
    0x0,

    /* U+F0C7 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe4, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0xf, 0xfe, 0x99, 0x99,
    0x99, 0x99, 0x9a, 0xff, 0xf5, 0x0, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf5, 0xf,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xf2, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0x5f, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xf5, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x5f, 0xff, 0xff, 0xff, 0xfb, 0xae, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xff, 0xf3, 0x0, 0xc,
    0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x5, 0xff, 0xff, 0xff, 0x5f, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xcf, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xa9, 0xef, 0xff, 0xff,
    0xff, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x1, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x10, 0x0,

    /* U+F0C9 "" */
    0xce, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x21, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6b, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xe3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F0E0 "" */
    0x7, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x2c, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x23, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x6, 0xf8,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x1b, 0xff, 0xfc, 0x22, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x4e, 0xff, 0xff, 0xff, 0x60, 0x8f,
    0xff, 0xff, 0xff, 0x80, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xb1, 0x4e, 0xff, 0xfe, 0x42, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe4, 0x19, 0xe9, 0x14,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x20, 0x29, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F0E7 "" */
    0x0, 0x2, 0x22, 0x22, 0x21, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xfc, 0x99, 0x99, 0x70, 0x9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x6, 0xaa, 0xaa, 0xbf, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x4, 0x74, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x33, 0x37, 0xff, 0xf8, 0x33, 0x31,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xfd, 0x3c, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xa0,
    0x9f, 0xff, 0xff, 0x10, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xcf, 0xff, 0xff, 0xf1, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xfe, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0x63, 0xde, 0xee,
    0xee, 0x1a, 0x40, 0x0, 0xff, 0xff, 0xf4, 0x7f,
    0xff, 0xff, 0xf1, 0xcf, 0x40, 0xf, 0xff, 0xff,
    0x47, 0xff, 0xff, 0xff, 0x1c, 0xff, 0x40, 0xff,
    0xff, 0xf4, 0x7f, 0xff, 0xff, 0xf1, 0xcf, 0xff,
    0x1f, 0xff, 0xff, 0x47, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0xff, 0xff, 0xf4, 0x7f, 0xff, 0xff,
    0xf9, 0x55, 0x55, 0xf, 0xff, 0xff, 0x47, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xf4,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xff, 0x47, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xff, 0xff, 0xf4, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x2a, 0xee, 0xee, 0x37, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x3, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xb0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18,
    0xef, 0xff, 0xa3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x58, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x17, 0x83, 0x0, 0x0, 0x0,
    0x0,

    /* U+F11C "" */
    0x19, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x60, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xa0, 0xf, 0x60,
    0xf, 0x60, 0xf, 0x60, 0xf, 0x60, 0xf, 0xfa,
    0xff, 0xa0, 0xe, 0x60, 0xe, 0x60, 0xe, 0x60,
    0xf, 0x60, 0xf, 0xfa, 0xff, 0xd5, 0x6f, 0xa5,
    0x6f, 0xa5, 0x6f, 0xa5, 0x6f, 0xa5, 0x6f, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xa0, 0xf,
    0x70, 0xf, 0x70, 0xf, 0x60, 0xf, 0xff, 0xfa,
    0xff, 0xff, 0x90, 0xf, 0x60, 0xf, 0x60, 0xf,
    0x60, 0xf, 0xff, 0xfa, 0xff, 0xff, 0xc5, 0x6f,
    0xa5, 0x6f, 0xa5, 0x6f, 0xa5, 0x6f, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xa0, 0xf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x60, 0xf, 0xfa,
    0xff, 0xa0, 0xe, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x60, 0xf, 0xfa, 0xff, 0xea, 0xaf, 0xda,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaf, 0xda, 0xaf, 0xfa,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xef,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x9f, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3a, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x4, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x5d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x6, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x8e, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x57, 0x77, 0x77, 0x77, 0xef,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78,
    0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x24, 0x44, 0x44, 0x44, 0x40, 0x11, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xf3, 0x5e, 0x30, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xe3, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfe, 0x30,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xff, 0xe3,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x47, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x73,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x16, 0x9c, 0xef, 0xfe, 0xda, 0x73, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x81, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x1, 0xbf,
    0xff, 0xff, 0xfb, 0x86, 0x55, 0x57, 0xae, 0xff,
    0xff, 0xfd, 0x30, 0x3, 0xef, 0xff, 0xfb, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x9f, 0xff, 0xff,
    0x60, 0xef, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2a, 0xff, 0xff, 0x25, 0xff,
    0x90, 0x0, 0x0, 0x2, 0x45, 0x64, 0x30, 0x0,
    0x0, 0x6, 0xff, 0x80, 0x4, 0x50, 0x0, 0x1,
    0x8d, 0xff, 0xff, 0xff, 0xea, 0x30, 0x0, 0x3,
    0x60, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xff, 0xee, 0xff, 0xff,
    0xff, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0x94, 0x0, 0x0, 0x37, 0xef, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xfc, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xdd, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x40, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F241 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F242 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x44, 0x44, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F243 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F244 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xbd,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x57, 0xcf, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x50, 0x6f,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x46, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x49, 0x93, 0x0, 0x6,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x0, 0x5f, 0xff, 0xf3, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xfa, 0x10, 0xd, 0xff,
    0xff, 0xd8, 0xcf, 0xa8, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x8f, 0xff, 0x70, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x2a, 0xff, 0xff, 0x70, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf8, 0x0, 0x1b,
    0xff, 0x90, 0x0, 0x0, 0xb, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x60, 0x2, 0x33, 0x31, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x10, 0xef, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xee, 0xbf,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x9b, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x22, 0x22, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x0, 0x1, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xbf, 0xff, 0xfe, 0xa3, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xdf, 0xff, 0xf7,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xe1, 0xef, 0xff,
    0xf5, 0x0, 0x3, 0xff, 0xff, 0xfe, 0x3, 0xff,
    0xff, 0xe0, 0x0, 0xaf, 0xff, 0xff, 0xe0, 0x4,
    0xff, 0xff, 0x40, 0xe, 0xff, 0xdf, 0xfe, 0x6,
    0x5, 0xff, 0xf9, 0x1, 0xff, 0xf1, 0x3f, 0xe0,
    0xca, 0x7, 0xff, 0xc0, 0x4f, 0xff, 0x90, 0x3d,
    0xb, 0x60, 0xbf, 0xfe, 0x5, 0xff, 0xff, 0x90,
    0x20, 0x30, 0xaf, 0xff, 0xf0, 0x6f, 0xff, 0xff,
    0x90, 0x0, 0x8f, 0xff, 0xff, 0x7, 0xff, 0xff,
    0xff, 0x50, 0x2f, 0xff, 0xff, 0xf1, 0x6f, 0xff,
    0xff, 0x90, 0x0, 0x7f, 0xff, 0xff, 0x5, 0xff,
    0xff, 0x90, 0x30, 0x30, 0x8f, 0xff, 0xf0, 0x4f,
    0xff, 0x90, 0x3e, 0xb, 0x60, 0x9f, 0xfe, 0x1,
    0xff, 0xf2, 0x4f, 0xf0, 0xc9, 0x6, 0xff, 0xc0,
    0xe, 0xff, 0xef, 0xff, 0x6, 0x5, 0xff, 0xf9,
    0x0, 0x8f, 0xff, 0xff, 0xf0, 0x4, 0xff, 0xff,
    0x40, 0x2, 0xff, 0xff, 0xff, 0x4, 0xff, 0xff,
    0xd0, 0x0, 0x6, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x5, 0xef, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x6a, 0xcd, 0xca,
    0x61, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x0, 0x35, 0x55, 0x55, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x79, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0xb, 0xff, 0xeb, 0xff,
    0xec, 0xff, 0xec, 0xff, 0xf1, 0x0, 0xbf, 0xf9,
    0x1f, 0xf8, 0x2f, 0xf7, 0x3f, 0xff, 0x10, 0xb,
    0xff, 0x91, 0xff, 0x82, 0xff, 0x73, 0xff, 0xf1,
    0x0, 0xbf, 0xf9, 0x1f, 0xf8, 0x2f, 0xf7, 0x3f,
    0xff, 0x10, 0xb, 0xff, 0x91, 0xff, 0x82, 0xff,
    0x73, 0xff, 0xf1, 0x0, 0xbf, 0xf9, 0x1f, 0xf8,
    0x2f, 0xf7, 0x3f, 0xff, 0x10, 0xb, 0xff, 0x91,
    0xff, 0x82, 0xff, 0x73, 0xff, 0xf1, 0x0, 0xbf,
    0xf9, 0x1f, 0xf8, 0x2f, 0xf7, 0x3f, 0xff, 0x10,
    0xb, 0xff, 0x91, 0xff, 0x82, 0xff, 0x73, 0xff,
    0xf1, 0x0, 0xbf, 0xf9, 0x1f, 0xf8, 0x2f, 0xf7,
    0x3f, 0xff, 0x10, 0xb, 0xff, 0xb3, 0xff, 0xa4,
    0xff, 0x95, 0xff, 0xf1, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x6, 0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x81,
    0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x15, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xef, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x31, 0x3f, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xed, 0x13, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xd1, 0x3f, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xff, 0xfd, 0x13, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xff,
    0xd1, 0x35, 0x0, 0x0, 0x0, 0x0, 0x3, 0xef,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0x97, 0x53, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x8, 0xbc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcb, 0x81, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x20, 0x0, 0x1d, 0xff, 0xff, 0xff, 0xfa, 0xef,
    0xff, 0xfa, 0xef, 0xff, 0xff, 0xf4, 0x0, 0x1d,
    0xff, 0xff, 0xff, 0xf8, 0x2, 0xef, 0xf8, 0x2,
    0xef, 0xff, 0xff, 0x40, 0x1d, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x2, 0xe8, 0x0, 0xd, 0xff, 0xff,
    0xf4, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x1, 0x0, 0xb, 0xff, 0xff, 0xff, 0x4c, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xf4, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0x43, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xf4, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xb, 0x40,
    0x2, 0xef, 0xff, 0xff, 0x40, 0x3, 0xff, 0xff,
    0xff, 0xff, 0x50, 0xb, 0xff, 0x40, 0xd, 0xff,
    0xff, 0xf4, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0x6c, 0xff, 0xff, 0x6b, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x2, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30,

    /* U+F7C2 "" */
    0x0, 0x0, 0x8, 0x99, 0x99, 0x99, 0x97, 0x20,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0xcf, 0x90, 0x6e, 0x3, 0xf3, 0xe, 0xfb,
    0xb, 0xff, 0x90, 0x6e, 0x2, 0xf2, 0xe, 0xfb,
    0xbf, 0xff, 0x90, 0x6e, 0x2, 0xf2, 0xe, 0xfb,
    0xff, 0xff, 0x90, 0x6e, 0x2, 0xf2, 0xe, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,
    0x2, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x10,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xf1, 0x0, 0x0, 0x3c, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xf1, 0x0, 0x3, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xf1, 0x0,
    0x4f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf1, 0x5, 0xff, 0xff, 0xb4, 0x44, 0x44,
    0x44, 0x44, 0x46, 0xff, 0xf1, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x3, 0xef,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x18, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 90, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 90, .box_w = 4, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28, .adv_w = 131, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 46, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 151, .adv_w = 209, .box_w = 13, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 281, .adv_w = 283, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 400, .adv_w = 230, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 513, .adv_w = 71, .box_w = 3, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 522, .adv_w = 113, .box_w = 5, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 570, .adv_w = 114, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 627, .adv_w = 134, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 659, .adv_w = 196, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 709, .adv_w = 76, .box_w = 3, .box_h = 6, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 718, .adv_w = 129, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 724, .adv_w = 76, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 730, .adv_w = 118, .box_w = 10, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 830, .adv_w = 224, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 914, .adv_w = 124, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 956, .adv_w = 193, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1040, .adv_w = 192, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1124, .adv_w = 225, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1222, .adv_w = 193, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1306, .adv_w = 207, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1390, .adv_w = 201, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1474, .adv_w = 216, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1565, .adv_w = 207, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1649, .adv_w = 76, .box_w = 4, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1671, .adv_w = 76, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1699, .adv_w = 196, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1749, .adv_w = 196, .box_w = 10, .box_h = 7, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 1784, .adv_w = 196, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1834, .adv_w = 193, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1911, .adv_w = 347, .box_w = 20, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2091, .adv_w = 246, .box_w = 17, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2210, .adv_w = 254, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2301, .adv_w = 243, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2399, .adv_w = 278, .box_w = 15, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2504, .adv_w = 225, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2581, .adv_w = 213, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2658, .adv_w = 259, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2756, .adv_w = 273, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2847, .adv_w = 104, .box_w = 3, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2868, .adv_w = 172, .box_w = 10, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2938, .adv_w = 242, .box_w = 14, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3036, .adv_w = 200, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3113, .adv_w = 321, .box_w = 16, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3225, .adv_w = 273, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3316, .adv_w = 282, .box_w = 16, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3428, .adv_w = 243, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3519, .adv_w = 282, .box_w = 17, .box_h = 17, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3664, .adv_w = 244, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3755, .adv_w = 209, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3846, .adv_w = 197, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3937, .adv_w = 266, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4028, .adv_w = 239, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4140, .adv_w = 378, .box_w = 23, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4301, .adv_w = 226, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4399, .adv_w = 217, .box_w = 15, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4504, .adv_w = 221, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4602, .adv_w = 112, .box_w = 5, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 4650, .adv_w = 118, .box_w = 9, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 4740, .adv_w = 112, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4788, .adv_w = 196, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 4833, .adv_w = 168, .box_w = 11, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4850, .adv_w = 202, .box_w = 6, .box_h = 3, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 4859, .adv_w = 201, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4914, .adv_w = 229, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5012, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5078, .adv_w = 229, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5176, .adv_w = 206, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5242, .adv_w = 119, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5310, .adv_w = 232, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5408, .adv_w = 229, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5498, .adv_w = 94, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5528, .adv_w = 95, .box_w = 7, .box_h = 19, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 5595, .adv_w = 207, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5685, .adv_w = 94, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5708, .adv_w = 355, .box_w = 20, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5818, .adv_w = 229, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5884, .adv_w = 213, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5956, .adv_w = 229, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6054, .adv_w = 229, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6152, .adv_w = 138, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6191, .adv_w = 168, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6246, .adv_w = 139, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6309, .adv_w = 227, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6375, .adv_w = 188, .box_w = 13, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6447, .adv_w = 302, .box_w = 19, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6552, .adv_w = 185, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6618, .adv_w = 188, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 6716, .adv_w = 175, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6777, .adv_w = 118, .box_w = 6, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6834, .adv_w = 100, .box_w = 3, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 6863, .adv_w = 118, .box_w = 7, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6930, .adv_w = 196, .box_w = 10, .box_h = 4, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 6950, .adv_w = 336, .box_w = 22, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7192, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7360, .adv_w = 336, .box_w = 21, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7570, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7738, .adv_w = 231, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7858, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8089, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8320, .adv_w = 378, .box_w = 24, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8560, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8791, .adv_w = 378, .box_w = 24, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8983, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9214, .adv_w = 168, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9308, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9444, .adv_w = 378, .box_w = 24, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9696, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9864, .adv_w = 231, .box_w = 15, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10029, .adv_w = 294, .box_w = 14, .box_h = 20, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 10169, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10378, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10568, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10758, .adv_w = 294, .box_w = 14, .box_h = 20, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 10898, .adv_w = 294, .box_w = 20, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 11098, .adv_w = 210, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11212, .adv_w = 210, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11326, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11516, .adv_w = 294, .box_w = 19, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 11564, .adv_w = 378, .box_w = 24, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11756, .adv_w = 420, .box_w = 27, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12053, .adv_w = 378, .box_w = 25, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 12328, .adv_w = 336, .box_w = 21, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12538, .adv_w = 294, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 12652, .adv_w = 294, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 12766, .adv_w = 420, .box_w = 27, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12982, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13150, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13381, .adv_w = 336, .box_w = 22, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 13623, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13813, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14022, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14212, .adv_w = 294, .box_w = 19, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 14374, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14542, .adv_w = 210, .box_w = 15, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 14707, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14916, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15125, .adv_w = 378, .box_w = 24, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15317, .adv_w = 336, .box_w = 23, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 15570, .adv_w = 252, .box_w = 16, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15746, .adv_w = 420, .box_w = 27, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16016, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16205, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16394, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16583, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16772, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16961, .adv_w = 420, .box_w = 27, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 17191, .adv_w = 294, .box_w = 17, .box_h = 22, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17378, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 17587, .adv_w = 336, .box_w = 22, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 17829, .adv_w = 420, .box_w = 27, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18045, .adv_w = 252, .box_w = 16, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 18221, .adv_w = 338, .box_w = 22, .box_h = 14, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x42,
    0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53,
    0x66, 0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77,
    0x78, 0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xc8,
    0xdf, 0xe6, 0xe9, 0xf2, 0x11b, 0x123, 0x15a, 0x1ea,
    0x23f, 0x240, 0x241, 0x242, 0x243, 0x286, 0x292, 0x2ec,
    0x303, 0x559, 0x7c1, 0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 60, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 0, 13, 14, 15, 16, 17,
    18, 19, 12, 20, 20, 0, 0, 0,
    21, 22, 23, 24, 25, 22, 26, 27,
    28, 29, 29, 30, 31, 32, 29, 29,
    22, 33, 34, 35, 3, 36, 30, 37,
    37, 38, 39, 40, 41, 42, 43, 0,
    44, 0, 45, 46, 47, 48, 49, 50,
    51, 45, 52, 52, 53, 48, 45, 45,
    46, 46, 54, 55, 56, 57, 51, 58,
    58, 59, 58, 60, 41, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 13, 14, 15, 16, 17, 12,
    18, 19, 20, 21, 21, 0, 0, 0,
    22, 23, 24, 25, 23, 25, 25, 25,
    23, 25, 25, 26, 25, 25, 25, 25,
    23, 25, 23, 25, 3, 27, 28, 29,
    29, 30, 31, 32, 33, 34, 35, 0,
    36, 0, 37, 38, 39, 39, 39, 0,
    39, 38, 40, 41, 38, 38, 42, 42,
    39, 42, 39, 42, 43, 44, 45, 46,
    46, 47, 46, 48, 0, 0, 35, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 3, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 15, 0, 9, -7, 0, 0, 0,
    0, -18, -20, 2, 16, 7, 6, -13,
    2, 16, 1, 14, 3, 11, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 3, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, -7,
    6, 7, 0, 0, -3, 0, -2, 3,
    0, -3, 0, -3, -2, -7, 0, 0,
    0, 0, -3, 0, 0, -4, -5, 0,
    0, -3, 0, -7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, -9, 0, -41, 0, 0, -7, 0,
    7, 10, 0, 0, -7, 3, 3, 11,
    7, -6, 7, 0, 0, -19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -12, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, -16, 0, -13, -2, 0, 0, 0,
    0, 1, 13, 0, -10, -3, -1, 1,
    0, -6, 0, 0, -2, -25, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -27, -3, 13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 0, 3, 0, 0, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 13, 3, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -12, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 7, 3, 10, -3, 0, 0, 7,
    -3, -11, -46, 2, 9, 7, 1, -4,
    0, 12, 0, 11, 0, 11, 0, -31,
    0, -4, 10, 0, 11, -3, 7, 3,
    0, 0, 1, -3, 0, 0, -6, 27,
    0, 27, 0, 10, 0, 14, 4, 6,
    0, 0, 0, -12, 0, 0, 0, 0,
    1, -2, 0, 2, -6, -4, -7, 2,
    0, -3, 0, 0, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -22, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, -18, 0, -21, 0, 0, 0, 0,
    -2, 0, 33, -4, -4, 3, 3, -3,
    0, -4, 3, 0, 0, -18, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -33, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 0, 0, -12, 0, 11, 0,
    -23, -33, -23, -7, 10, 0, 0, -23,
    0, 4, -8, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 9, 10, -41, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 2,
    2, -4, -7, 0, -1, -1, -3, 0,
    0, -2, 0, 0, 0, -7, 0, -3,
    0, -8, -7, 0, -8, -11, -11, -6,
    0, -7, 0, -7, 0, 0, 0, 0,
    -3, 0, 0, 3, 0, 2, -3, 0,
    0, 0, 0, 3, -2, 0, 0, 0,
    -2, 3, 3, -1, 0, 0, 0, -6,
    0, -1, 0, 0, 0, 0, 0, 1,
    0, 4, -2, 0, -4, 0, -6, 0,
    0, -2, 0, 10, 0, 0, -3, 0,
    0, 0, 0, 0, -1, 1, -2, -2,
    0, -3, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -2, 0,
    -3, -4, 0, 0, 0, 0, 0, 1,
    0, 0, -2, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, -2, -4, 0,
    0, -10, -2, -10, 7, 0, 0, -7,
    3, 7, 9, 0, -8, -1, -4, 0,
    -1, -16, 3, -2, 2, -18, 3, 0,
    0, 1, -17, 0, -18, -3, -29, -2,
    0, -17, 0, 7, 9, 0, 4, 0,
    0, 0, 0, 1, 0, -6, -4, 0,
    0, 0, 0, -3, 0, 0, 0, -3,
    0, 0, 0, 0, 0, -2, -2, 0,
    -2, -4, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, -2, -4, -3, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, -2, 0, -7, 3, 0, 0, -4,
    2, 3, 3, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 2,
    0, 0, -3, 0, -3, -2, -4, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    -3, 0, 0, 0, 0, -4, -5, 0,
    0, 10, -2, 1, -11, 0, 0, 9,
    -17, -17, -14, -7, 3, 0, -3, -22,
    -6, 0, -6, 0, -7, 5, -6, -22,
    0, -9, 0, 0, 2, -1, 3, -2,
    0, 3, 0, -10, -13, 0, -17, -8,
    -7, -8, -10, -4, -9, -1, -6, -9,
    0, 1, 0, -3, 0, 0, 0, 2,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -2,
    0, -1, -3, 0, -6, -7, -7, -1,
    0, -10, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 1, -2, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 16, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, -6, 0, 0, 0,
    0, -17, -10, 0, 0, 0, -5, -17,
    0, 0, -3, 3, 0, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, 0, 0, 0, 0, 4, 0,
    2, -7, -7, 0, -3, -3, -4, 0,
    0, 0, 0, 0, 0, -10, 0, -3,
    0, -5, -3, 0, -7, -8, -10, -3,
    0, -7, 0, -10, 0, 0, 0, 0,
    27, 0, 0, 2, 0, 0, -4, 0,
    0, -14, 0, 0, 0, 0, 0, -31,
    -6, 11, 10, -3, -14, 0, 3, -5,
    0, -17, -2, -4, 3, -24, -3, 4,
    0, 5, -12, -5, -12, -11, -14, 0,
    0, -20, 0, 19, 0, 0, -2, 0,
    0, 0, -2, -2, -3, -9, -11, -1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, -2, -3, -5, 0,
    0, -7, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -1, 0, -7, 0, 0, 7,
    -1, 4, 0, -7, 3, -2, -1, -9,
    -3, 0, -4, -3, -2, 0, -5, -6,
    0, 0, -3, -1, -2, -6, -4, 0,
    0, -3, 0, 3, -2, 0, -7, 0,
    0, 0, -7, 0, -6, 0, -6, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    -7, 3, 0, -5, 0, -2, -4, -10,
    -2, -2, -2, -1, -2, -4, -1, 0,
    0, 0, 0, 0, -3, -3, -3, 0,
    0, 0, 0, 4, -2, 0, -2, 0,
    0, 0, -2, -4, -2, -3, -4, -3,
    3, 13, -1, 0, -9, 0, -2, 7,
    0, -3, -14, -4, 5, 0, 0, -16,
    -6, 3, -6, 2, 0, -2, -3, -11,
    0, -5, 2, 0, 0, -6, 0, 0,
    0, 3, 3, -7, -6, 0, -6, -3,
    -5, -3, -3, 0, -6, 2, -6, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, 0, -4, 0, 0, -3, -3, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, 0, -2, 0,
    0, 0, -5, 0, -7, 0, 0, 0,
    -11, 0, 2, -7, 7, 1, -2, -16,
    0, 0, -7, -3, 0, -13, -8, -9,
    0, 0, -14, -3, -13, -13, -16, 0,
    -9, 0, 3, 23, -4, 0, -8, -3,
    -1, -3, -6, -9, -6, -12, -14, -8,
    0, 0, -2, 0, 1, 0, 0, -24,
    -3, 10, 7, -7, -12, 0, 1, -10,
    0, -17, -2, -3, 7, -31, -4, 1,
    0, 0, -22, -4, -17, -3, -25, 0,
    0, -24, 0, 20, 1, 0, -2, 0,
    0, 0, 0, -2, -2, -13, -2, 0,
    0, 0, 0, 0, -11, 0, -3, 0,
    -1, -9, -16, 0, 0, -2, -5, -10,
    -3, 0, -2, 0, 0, 0, 0, -15,
    -3, -11, -11, -3, -6, -8, -3, -6,
    0, -7, -3, -11, -5, 0, -4, -6,
    -3, -6, 0, 2, 0, -2, -11, 0,
    0, -6, 0, 0, 0, 0, 4, 0,
    2, -7, 14, 0, -3, -3, -4, 0,
    0, 0, 0, 0, 0, -10, 0, -3,
    0, -5, -3, 0, -7, -8, -10, -3,
    0, -7, 3, 13, 0, 0, 0, 0,
    27, 0, 0, 2, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, 0, 0, 0, -2, -7,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, -3, -3, 0, 0, -7, -3, 0,
    0, -7, 0, 6, -2, 0, 0, 0,
    0, 0, 0, 2, 0, 0, 0, 0,
    7, 3, -3, 0, -11, -5, 0, 10,
    -11, -11, -7, -7, 13, 6, 3, -29,
    -2, 7, -3, 0, -3, 4, -3, -12,
    0, -3, 3, -4, -3, -10, -3, 0,
    0, 10, 7, 0, -9, 0, -18, -4,
    10, -4, -13, 1, -4, -11, -11, -3,
    3, 0, -5, 0, -9, 0, 3, 11,
    -8, -12, -13, -8, 10, 0, 1, -25,
    -3, 3, -6, -2, -8, 0, -7, -12,
    -5, -5, -3, 0, 0, -8, -7, -3,
    0, 10, 8, -3, -18, 0, -18, -5,
    0, -12, -19, -1, -11, -6, -11, -9,
    0, 0, -4, 0, -7, -3, 0, -3,
    -6, 0, 6, -11, 3, 0, 0, -18,
    0, -3, -7, -6, -2, -10, -8, -11,
    -8, 0, -10, -3, -8, -6, -10, -3,
    0, 0, 1, 16, -6, 0, -10, -3,
    0, -3, -7, -8, -9, -9, -13, -4,
    7, 0, -5, 0, -17, -4, 2, 7,
    -11, -12, -7, -11, 11, -3, 2, -31,
    -6, 7, -7, -6, -12, 0, -10, -14,
    -4, -3, -3, -3, -7, -10, -1, 0,
    0, 10, 9, -2, -22, 0, -20, -8,
    8, -13, -23, -7, -12, -14, -17, -11,
    0, 0, 0, 0, -4, 0, 0, 3,
    -4, 7, 2, -6, 7, 0, 0, -10,
    -1, 0, -1, 0, 1, 1, -3, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 3, 10, 1, 0, -4, 0,
    0, 0, 0, -2, -2, -4, 0, 0,
    1, 3, 0, 0, 0, 0, 3, 0,
    -3, 0, 13, 0, 6, 1, 1, -4,
    0, 7, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, 0, -3, 6, 0, 10, 0,
    0, 33, 4, -7, -7, 3, 3, -2,
    1, -17, 0, 0, 16, -20, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -23, 13, 47, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, -6, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, -9, 0, 0, 1, 0,
    0, 3, 43, -7, -3, 11, 9, -9,
    3, 0, 0, 3, 3, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -44, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -9, 0, 0, 0, -9,
    0, 0, 0, 0, -7, -2, 0, 0,
    0, -7, 0, -4, 0, -16, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -23, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, -5, 0, -9, 0, 0, 0, -6,
    3, -4, 0, 0, -9, -3, -8, 0,
    0, -9, 0, -3, 0, -16, 0, -4,
    0, 0, -27, -6, -13, -4, -12, 0,
    0, -23, 0, -9, -2, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -6, -3,
    0, 0, 0, 0, -7, 0, -7, 4,
    -4, 7, 0, -2, -8, -2, -6, -6,
    0, -4, -2, -2, 2, -9, -1, 0,
    0, 0, -30, -3, -5, 0, -7, 0,
    -2, -16, -3, 0, 0, -2, -3, 0,
    0, 0, 0, 2, 0, -2, -6, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, -7, 0, -2, 0, 0, 0, -7,
    3, 0, 0, 0, -9, -3, -7, 0,
    0, -9, 0, -3, 0, -16, 0, 0,
    0, 0, -33, 0, -7, -12, -17, 0,
    0, -23, 0, -2, -5, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -5, -2,
    1, 0, 0, 6, -4, 0, 10, 16,
    -3, -3, -10, 4, 16, 6, 7, -9,
    4, 14, 4, 10, 7, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 21, 16, -6, -3, 0, -3, 27,
    14, 27, 0, 0, 0, 3, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0,
    0, 0, -28, -4, -3, -14, -16, 0,
    0, -23, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0,
    0, 0, -28, -4, -3, -14, -16, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -3, 0, 0, 0,
    -8, 3, 0, -3, 3, 6, 3, -10,
    0, -1, -3, 3, 0, 3, 0, 0,
    0, 0, -8, 0, -3, -2, -7, 0,
    -3, -13, 0, 21, -3, 0, -7, -2,
    0, -2, -6, 0, -3, -9, -7, -4,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0,
    0, 0, -28, -4, -3, -14, -16, 0,
    0, -23, 0, 0, 0, 0, 0, 0,
    17, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, -11, -4, -3, 10,
    -3, -3, -13, 1, -2, 1, -2, -9,
    1, 7, 1, 3, 1, 3, -8, -13,
    -4, 0, -13, -6, -9, -14, -13, 0,
    -5, -7, -4, -4, -3, -2, -4, -2,
    0, -2, -1, 5, 0, 5, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, -3, -3, 0,
    0, -9, 0, -2, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, 0, 0, 0, -3, 0, 0, -6,
    -3, 3, 0, -6, -6, -2, 0, -10,
    -2, -7, -2, -4, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -23, 0, 11, 0, 0, -6, 0,
    0, 0, 0, -4, 0, -3, 0, 0,
    0, 0, -2, 0, -8, 0, 0, 14,
    -4, -11, -10, 2, 4, 4, -1, -9,
    2, 5, 2, 10, 2, 11, -2, -9,
    0, 0, -13, 0, 0, -10, -9, 0,
    0, -7, 0, -4, -6, 0, -5, 0,
    -5, 0, -2, 5, 0, -3, -10, -3,
    0, 0, -3, 0, -7, 0, 0, 4,
    -8, 0, 3, -3, 3, 0, 0, -11,
    0, -2, -1, 0, -3, 4, -3, 0,
    0, 0, -14, -4, -7, 0, -10, 0,
    0, -16, 0, 12, -3, 0, -6, 0,
    2, 0, -3, 0, -3, -10, 0, -3,
    0, 0, 0, 0, -2, 0, 0, 3,
    -4, 1, 0, 0, -4, -2, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -21, 0, 7, 0, 0, -3, 0,
    0, 0, 0, 1, 0, -3, -3, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 60,
    .right_class_cnt     = 48,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t lv_font_montserratMedium_21 = {
#else
lv_font_t lv_font_montserratMedium_21 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 23,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if LV_FONT_MONTSERRATMEDIUM_21*/

