/*
* Copyright 2016 The Alatsi Project Authors (https://github.com/sorkintype/alatsi).
* This Font Software is licensed under the SIL Open Font License, Version 1.1.
* And is also available with a FAQ at: http://scripts.sil.org/OFL
*/
/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: undefined
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef LV_FONT_ALATSI_REGULAR_16
#define LV_FONT_ALATSI_REGULAR_16 1
#endif

#if LV_FONT_ALATSI_REGULAR_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x8f, 0x98, 0xf9, 0x8f, 0x87, 0xf8, 0x7f, 0x86,
    0xf7, 0x6f, 0x76, 0xf6, 0x1, 0x2, 0x52, 0x6f,
    0x76, 0xf7,

    /* U+0022 "\"" */
    0x9f, 0x22, 0xf8, 0x8f, 0x22, 0xf8, 0x8f, 0x11,
    0xf7, 0x7f, 0x11, 0xf7, 0x6f, 0x0, 0xf6, 0x14,
    0x0, 0x41,

    /* U+0023 "#" */
    0x0, 0xb, 0xa0, 0x7e, 0x0, 0x0, 0xd, 0x80,
    0x9c, 0x0, 0x0, 0xf, 0x70, 0xba, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xf3, 0x2, 0x5f, 0x53, 0xf8,
    0x30, 0x0, 0x5f, 0x11, 0xf5, 0x0, 0x0, 0x7f,
    0x3, 0xf3, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xc0,
    0x3, 0xbc, 0x38, 0xf3, 0x20, 0x0, 0xc9, 0x8,
    0xd0, 0x0, 0x0, 0xe7, 0xa, 0xb0, 0x0,

    /* U+0024 "$" */
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x1a, 0xfa, 0x10,
    0x4, 0xff, 0xdf, 0xf2, 0xd, 0xf3, 0x0, 0x60,
    0xe, 0xf4, 0x0, 0x0, 0x7, 0xff, 0xc7, 0x10,
    0x0, 0x6d, 0xff, 0xe2, 0x0, 0x0, 0x3b, 0xfb,
    0x2, 0x0, 0x4, 0xfc, 0xd, 0xd8, 0x8d, 0xf6,
    0x2, 0x9d, 0xfc, 0x50, 0x0, 0x7, 0xf6, 0x0,

    /* U+0025 "%" */
    0x4, 0xdf, 0xb2, 0x0, 0xc, 0xc0, 0x0, 0xe,
    0xc4, 0xfb, 0x0, 0x5f, 0x30, 0x0, 0x3f, 0x70,
    0xcf, 0x0, 0xda, 0x0, 0x0, 0x3f, 0x70, 0xcf,
    0x7, 0xf2, 0x0, 0x0, 0x1f, 0xa1, 0xec, 0x1f,
    0x80, 0x0, 0x0, 0x6, 0xff, 0xe3, 0x9e, 0x17,
    0xee, 0x90, 0x0, 0x2, 0x2, 0xf7, 0x4f, 0x87,
    0xf7, 0x0, 0x0, 0xa, 0xd0, 0x7f, 0x20, 0xfb,
    0x0, 0x0, 0x3f, 0x50, 0x8f, 0x20, 0xfb, 0x0,
    0x0, 0xcc, 0x0, 0x4f, 0x64, 0xf7, 0x0, 0x5,
    0xf3, 0x0, 0x7, 0xee, 0xa0,

    /* U+0026 "&" */
    0x0, 0x6d, 0xfd, 0x40, 0x0, 0x5, 0xfc, 0x6e,
    0xf1, 0x0, 0xa, 0xf2, 0x9, 0xf4, 0x0, 0x9,
    0xf5, 0xb, 0xf1, 0x0, 0x3, 0xfe, 0x7f, 0x80,
    0x0, 0x0, 0x8f, 0xf9, 0x0, 0x0, 0x6, 0xfc,
    0xfd, 0x13, 0xd4, 0xf, 0xd0, 0x7f, 0xcb, 0xf4,
    0x3f, 0xd0, 0x8, 0xff, 0xa0, 0xd, 0xfb, 0x9d,
    0xff, 0xb0, 0x2, 0xae, 0xfc, 0x6b, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+0027 "'" */
    0x9f, 0x28, 0xf2, 0x8f, 0x17, 0xf1, 0x6f, 0x1,
    0x40,

    /* U+0028 "(" */
    0x0, 0x6, 0x50, 0xa, 0xf3, 0x7, 0xf5, 0x1,
    0xfd, 0x0, 0x6f, 0x70, 0xb, 0xf3, 0x0, 0xdf,
    0x10, 0xf, 0xf0, 0x0, 0xef, 0x0, 0xd, 0xf1,
    0x0, 0x9f, 0x40, 0x4, 0xf8, 0x0, 0xc, 0xe1,
    0x0, 0x3f, 0xb0, 0x0, 0x4e, 0x90, 0x0, 0x11,

    /* U+0029 ")" */
    0x7, 0x20, 0x0, 0x9, 0xf3, 0x0, 0x0, 0xce,
    0x10, 0x0, 0x3f, 0x90, 0x0, 0xe, 0xf0, 0x0,
    0xa, 0xf4, 0x0, 0x8, 0xf7, 0x0, 0x7, 0xf8,
    0x0, 0x7, 0xf8, 0x0, 0x8, 0xf7, 0x0, 0xa,
    0xf3, 0x0, 0xe, 0xe0, 0x0, 0x6f, 0x70, 0x2,
    0xfc, 0x0, 0xe, 0xc1, 0x0, 0x3, 0x0, 0x0,

    /* U+002A "*" */
    0x0, 0xd, 0xb0, 0x0, 0x5, 0xc, 0xa0, 0x50,
    0x4f, 0xee, 0xef, 0xf3, 0x2, 0x9f, 0xf8, 0x20,
    0x1, 0xdc, 0xdc, 0x0, 0x7, 0xf2, 0x3f, 0x50,
    0x0, 0x20, 0x2, 0x0,

    /* U+002B "+" */
    0x0, 0x4, 0xd5, 0x0, 0x0, 0x0, 0x5f, 0x60,
    0x0, 0x0, 0x5, 0xf6, 0x0, 0x2, 0x88, 0xbf,
    0xb8, 0x84, 0x5f, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x5f, 0x60, 0x0, 0x0, 0x5, 0xf6, 0x0, 0x0,
    0x0, 0x5f, 0x60, 0x0,

    /* U+002C "," */
    0x2e, 0x92, 0xf9, 0x3f, 0x83, 0xf6, 0x5f, 0x20,

    /* U+002D "-" */
    0x78, 0x88, 0x81, 0xef, 0xff, 0xf3,

    /* U+002E "." */
    0x15, 0x33, 0xfa, 0x3f, 0xa0,

    /* U+002F "/" */
    0x0, 0x0, 0x4, 0x70, 0x0, 0x0, 0xc, 0xc0,
    0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0x6f, 0x20,
    0x0, 0x0, 0xae, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0xbd, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x4, 0xf4, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0x2f, 0x60, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x6d, 0xfe, 0x80, 0x0, 0x6f, 0xfb, 0xef,
    0xb0, 0xe, 0xf6, 0x2, 0xff, 0x33, 0xff, 0x0,
    0xb, 0xf8, 0x5f, 0xe0, 0x0, 0x9f, 0xa6, 0xfd,
    0x0, 0x8, 0xfb, 0x5f, 0xe0, 0x0, 0x9f, 0xa3,
    0xff, 0x0, 0xb, 0xf8, 0xe, 0xf6, 0x2, 0xff,
    0x30, 0x6f, 0xfb, 0xef, 0xb0, 0x0, 0x6d, 0xfe,
    0x90, 0x0,

    /* U+0031 "1" */
    0x0, 0x3, 0xb9, 0x9f, 0x99, 0xf9, 0x9f, 0x99,
    0xf9, 0x9f, 0x99, 0xf9, 0x9f, 0x99, 0xf9, 0x9f,
    0x99, 0xf9,

    /* U+0032 "2" */
    0x0, 0x7d, 0xfe, 0x80, 0x0, 0xbf, 0xec, 0xff,
    0xa0, 0x3f, 0xd0, 0x3, 0xff, 0x0, 0x54, 0x0,
    0xf, 0xf1, 0x0, 0x0, 0x6, 0xfd, 0x0, 0x0,
    0x7, 0xff, 0x40, 0x0, 0x3d, 0xfd, 0x30, 0x0,
    0x4f, 0xf8, 0x0, 0x0, 0xd, 0xf5, 0x0, 0x0,
    0x1, 0xff, 0xcc, 0xcc, 0xc2, 0xf, 0xff, 0xff,
    0xff, 0x30,

    /* U+0033 "3" */
    0x7, 0xcf, 0xfd, 0x70, 0x2, 0xff, 0xdd, 0xff,
    0x70, 0x5, 0x10, 0x9, 0xfc, 0x0, 0x0, 0x0,
    0x9f, 0x90, 0x0, 0x29, 0xbf, 0xe1, 0x0, 0x4,
    0xff, 0xfb, 0x10, 0x0, 0x0, 0x1a, 0xfc, 0x0,
    0x0, 0x0, 0x3f, 0xf0, 0x6, 0x10, 0x8, 0xff,
    0x1, 0xff, 0xde, 0xff, 0x70, 0x7, 0xdf, 0xfc,
    0x50, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x9f, 0xff, 0x0, 0x0, 0x1, 0xfe,
    0xef, 0x0, 0x0, 0x8, 0xf8, 0xef, 0x0, 0x0,
    0xe, 0xf1, 0xff, 0x0, 0x0, 0x7f, 0xb0, 0xff,
    0x0, 0x0, 0xef, 0x40, 0xff, 0x0, 0x6, 0xfd,
    0x0, 0xff, 0x0, 0xd, 0xfc, 0x88, 0xff, 0x82,
    0x4f, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x1,
    0xff, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0,

    /* U+0035 "5" */
    0x9, 0xff, 0xff, 0xf9, 0x0, 0xaf, 0xba, 0xaa,
    0x60, 0xa, 0xf2, 0x0, 0x0, 0x0, 0xbf, 0x78,
    0x61, 0x0, 0xb, 0xff, 0xff, 0xf3, 0x0, 0x42,
    0x3, 0xcf, 0xd0, 0x0, 0x0, 0x3, 0xff, 0x0,
    0x0, 0x0, 0x2f, 0xf0, 0x3, 0x0, 0x8, 0xfc,
    0x0, 0xfe, 0xbd, 0xff, 0x30, 0x19, 0xef, 0xea,
    0x20, 0x0,

    /* U+0036 "6" */
    0x0, 0x6, 0xcf, 0xfb, 0x20, 0x0, 0x9f, 0xfc,
    0xcf, 0x20, 0x5, 0xfe, 0x20, 0x0, 0x0, 0xb,
    0xf5, 0x48, 0x83, 0x0, 0xf, 0xfa, 0xff, 0xff,
    0x60, 0xf, 0xff, 0x40, 0x7f, 0xf0, 0xf, 0xf6,
    0x0, 0xe, 0xf3, 0xe, 0xf6, 0x0, 0xe, 0xf3,
    0x9, 0xfc, 0x0, 0x4f, 0xf0, 0x1, 0xef, 0xda,
    0xff, 0x70, 0x0, 0x1a, 0xef, 0xc5, 0x0,

    /* U+0037 "7" */
    0x4f, 0xff, 0xff, 0xfd, 0x3, 0xdd, 0xdd, 0xff,
    0x80, 0x0, 0x0, 0xd, 0xf3, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x9f, 0x80, 0x0, 0x0,
    0xe, 0xf3, 0x0, 0x0, 0x4, 0xfe, 0x0, 0x0,
    0x0, 0xaf, 0x90, 0x0, 0x0, 0xf, 0xf4, 0x0,
    0x0, 0x5, 0xfe, 0x0, 0x0, 0x0, 0xaf, 0x90,
    0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x6c, 0xff, 0xc5, 0x0, 0x6, 0xfe, 0x88,
    0xff, 0x50, 0xb, 0xf7, 0x0, 0x8f, 0xa0, 0xa,
    0xf8, 0x0, 0x9f, 0x80, 0x2, 0xef, 0xaa, 0xfd,
    0x10, 0x1, 0xaf, 0xff, 0xf9, 0x0, 0xd, 0xf9,
    0x11, 0xbf, 0xc0, 0x3f, 0xf1, 0x0, 0x3f, 0xf1,
    0x2f, 0xf4, 0x0, 0x5f, 0xf0, 0xa, 0xff, 0xaa,
    0xff, 0x90, 0x0, 0x7d, 0xff, 0xc6, 0x0,

    /* U+0039 "9" */
    0x0, 0x4b, 0xef, 0xb3, 0x0, 0x5, 0xff, 0xcb,
    0xff, 0x30, 0xd, 0xf7, 0x0, 0x7f, 0xc0, 0xf,
    0xf1, 0x0, 0x2f, 0xf1, 0xf, 0xf5, 0x0, 0x7f,
    0xf3, 0x8, 0xff, 0xac, 0xfe, 0xf4, 0x0, 0x8e,
    0xfc, 0x4e, 0xf2, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0x0, 0x20, 0x1, 0xcf, 0x80, 0x0, 0xee, 0xcf,
    0xfc, 0x0, 0x1, 0xae, 0xfd, 0x80, 0x0,

    /* U+003A ":" */
    0x3f, 0xa3, 0xfa, 0x15, 0x30, 0x0, 0x0, 0x1,
    0x53, 0x3f, 0xa3, 0xfa,

    /* U+003B ";" */
    0x3f, 0xa3, 0xfa, 0x15, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xa2, 0xf9, 0x3f, 0x84, 0xf5, 0x5e,
    0x10,

    /* U+003C "<" */
    0x0, 0x0, 0x7, 0x30, 0x0, 0x4d, 0xf3, 0x1,
    0xaf, 0xd4, 0x6, 0xff, 0x70, 0x0, 0xbf, 0x70,
    0x0, 0x3, 0xcf, 0xb2, 0x0, 0x0, 0x6e, 0xf8,
    0x0, 0x0, 0x19, 0xf3, 0x0, 0x0, 0x3, 0x20,

    /* U+003D "=" */
    0x1f, 0xff, 0xff, 0xfb, 0x8, 0x88, 0x88, 0x86,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xfb, 0x8, 0x88, 0x88, 0x86,

    /* U+003E ">" */
    0x72, 0x0, 0x0, 0xb, 0xf9, 0x10, 0x0, 0x8,
    0xfe, 0x60, 0x0, 0x2, 0xcf, 0xc1, 0x0, 0x1,
    0xdf, 0x30, 0x6, 0xff, 0x80, 0x3d, 0xfb, 0x20,
    0xb, 0xe5, 0x0, 0x0, 0x50, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x3, 0xbf, 0xec, 0x40, 0xe, 0xfc, 0xdf, 0xf2,
    0x5, 0x50, 0xc, 0xf6, 0x0, 0x0, 0xb, 0xf5,
    0x0, 0x0, 0x6f, 0xb0, 0x0, 0x8, 0xfa, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x1f, 0xa0, 0x0,
    0x0, 0x3, 0x10, 0x0, 0x0, 0x5, 0x40, 0x0,
    0x0, 0xf, 0xc0, 0x0, 0x0, 0xf, 0xc0, 0x0,

    /* U+0040 "@" */
    0x0, 0x1, 0x8c, 0xed, 0x92, 0x0, 0x0, 0x5e,
    0x93, 0x23, 0x8f, 0x40, 0x3, 0xf3, 0x0, 0x0,
    0x6, 0xe0, 0xd, 0x60, 0x6d, 0xda, 0xe0, 0xf4,
    0x2f, 0x4, 0xf7, 0x3d, 0xb0, 0xd5, 0x6c, 0xb,
    0xd0, 0xd, 0x70, 0xd5, 0x7a, 0xe, 0xa0, 0x3f,
    0x30, 0xf2, 0x7b, 0xd, 0xc0, 0xcf, 0x27, 0xb0,
    0x4e, 0x5, 0xfd, 0x4e, 0xfb, 0x10, 0xd, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf9, 0x30, 0x13,
    0x90, 0x0, 0x0, 0x19, 0xdf, 0xfd, 0x91, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xa0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0x20, 0x0, 0x0, 0x7,
    0xfc, 0xf8, 0x0, 0x0, 0x0, 0xef, 0x2f, 0xe0,
    0x0, 0x0, 0x5f, 0xb0, 0xaf, 0x60, 0x0, 0xc,
    0xf5, 0x3, 0xfd, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0xaf, 0xc8, 0x88, 0xbf, 0xb0, 0x1f,
    0xf2, 0x0, 0x1, 0xff, 0x20,

    /* U+0042 "B" */
    0xaf, 0xff, 0xd8, 0x0, 0xaf, 0xb9, 0xdf, 0xa0,
    0xaf, 0x50, 0x1f, 0xf0, 0xaf, 0x50, 0xf, 0xf0,
    0xaf, 0x72, 0x8f, 0xa0, 0xaf, 0xff, 0xff, 0x40,
    0xaf, 0x95, 0x7f, 0xf4, 0xaf, 0x50, 0x8, 0xf9,
    0xaf, 0x50, 0xa, 0xf9, 0xaf, 0xb9, 0xbf, 0xf3,
    0xaf, 0xff, 0xeb, 0x40,

    /* U+0043 "C" */
    0x0, 0x19, 0xef, 0xd7, 0x0, 0x2e, 0xff, 0xdf,
    0xd0, 0xc, 0xfb, 0x0, 0x13, 0x2, 0xff, 0x20,
    0x0, 0x0, 0x5f, 0xe0, 0x0, 0x0, 0x6, 0xfd,
    0x0, 0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0, 0x1,
    0xff, 0x30, 0x0, 0x0, 0xb, 0xfb, 0x0, 0x2,
    0x0, 0x2e, 0xfe, 0xdf, 0xd0, 0x0, 0x2a, 0xef,
    0xd7, 0x0,

    /* U+0044 "D" */
    0xbf, 0xff, 0xd9, 0x10, 0xb, 0xfb, 0x9d, 0xfe,
    0x10, 0xbf, 0x50, 0xb, 0xfa, 0xb, 0xf5, 0x0,
    0x3f, 0xf0, 0xbf, 0x50, 0x0, 0xff, 0x2b, 0xf5,
    0x0, 0xd, 0xf3, 0xbf, 0x50, 0x0, 0xff, 0x2b,
    0xf5, 0x0, 0x3f, 0xe0, 0xbf, 0x50, 0x1d, 0xf8,
    0xb, 0xfd, 0xcf, 0xfc, 0x0, 0xbf, 0xff, 0xd7,
    0x0, 0x0,

    /* U+0045 "E" */
    0xbf, 0xff, 0xff, 0x2b, 0xfc, 0xbb, 0xb1, 0xbf,
    0x40, 0x0, 0xb, 0xf4, 0x0, 0x0, 0xbf, 0xca,
    0xa3, 0xb, 0xff, 0xff, 0x50, 0xbf, 0x40, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0xbf, 0x40, 0x0, 0xb,
    0xfd, 0xcc, 0xc5, 0xbf, 0xff, 0xff, 0x70,

    /* U+0046 "F" */
    0xaf, 0xff, 0xff, 0x2a, 0xfd, 0xbb, 0xb1, 0xaf,
    0x60, 0x0, 0xa, 0xf6, 0x0, 0x0, 0xaf, 0x60,
    0x0, 0xa, 0xff, 0xff, 0xb0, 0xaf, 0xdc, 0xc8,
    0xa, 0xf6, 0x0, 0x0, 0xaf, 0x60, 0x0, 0xa,
    0xf6, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x18, 0xdf, 0xfb, 0x30, 0x1, 0xdf, 0xfe,
    0xff, 0x80, 0xb, 0xfc, 0x20, 0x5, 0x0, 0x1f,
    0xf2, 0x0, 0x0, 0x0, 0x5f, 0xd0, 0x0, 0x0,
    0x0, 0x6f, 0xc0, 0xb, 0xff, 0xf7, 0x4f, 0xd0,
    0x8, 0xbd, 0xf8, 0x1f, 0xf1, 0x0, 0x7, 0xf6,
    0xb, 0xfb, 0x0, 0xd, 0xf3, 0x2, 0xef, 0xec,
    0xff, 0xb0, 0x0, 0x19, 0xef, 0xe9, 0x10,

    /* U+0048 "H" */
    0xaf, 0x60, 0x0, 0xef, 0x2a, 0xf6, 0x0, 0xe,
    0xf2, 0xaf, 0x60, 0x0, 0xef, 0x2a, 0xf6, 0x0,
    0xe, 0xf2, 0xaf, 0xdb, 0xbb, 0xff, 0x2a, 0xff,
    0xff, 0xff, 0xf2, 0xaf, 0x60, 0x0, 0xef, 0x2a,
    0xf6, 0x0, 0xe, 0xf2, 0xaf, 0x60, 0x0, 0xef,
    0x2a, 0xf6, 0x0, 0xe, 0xf2, 0xaf, 0x60, 0x0,
    0xef, 0x20,

    /* U+0049 "I" */
    0xbf, 0x5b, 0xf5, 0xbf, 0x5b, 0xf5, 0xbf, 0x5b,
    0xf5, 0xbf, 0x5b, 0xf5, 0xbf, 0x5b, 0xf5, 0xbf,
    0x50,

    /* U+004A "J" */
    0x0, 0x0, 0xdf, 0x30, 0x0, 0xd, 0xf3, 0x0,
    0x0, 0xdf, 0x30, 0x0, 0xd, 0xf3, 0x0, 0x0,
    0xdf, 0x30, 0x0, 0xd, 0xf3, 0x0, 0x0, 0xdf,
    0x30, 0x0, 0xd, 0xf3, 0x1, 0x0, 0xff, 0x10,
    0xbd, 0xef, 0xc0, 0xb, 0xff, 0xb1, 0x0,

    /* U+004B "K" */
    0xaf, 0x60, 0x6, 0xfe, 0xa, 0xf6, 0x1, 0xff,
    0x30, 0xaf, 0x60, 0xbf, 0x80, 0xa, 0xf6, 0x5f,
    0xd0, 0x0, 0xaf, 0x7e, 0xf2, 0x0, 0xa, 0xfe,
    0xfa, 0x0, 0x0, 0xaf, 0x8f, 0xf4, 0x0, 0xa,
    0xf6, 0x6f, 0xe1, 0x0, 0xaf, 0x60, 0xbf, 0xb0,
    0xa, 0xf6, 0x1, 0xff, 0x60, 0xaf, 0x60, 0x5,
    0xff, 0x30,

    /* U+004C "L" */
    0xaf, 0x60, 0x0, 0xaf, 0x60, 0x0, 0xaf, 0x60,
    0x0, 0xaf, 0x60, 0x0, 0xaf, 0x60, 0x0, 0xaf,
    0x60, 0x0, 0xaf, 0x60, 0x0, 0xaf, 0x60, 0x0,
    0xaf, 0x60, 0x0, 0xaf, 0xdb, 0xb8, 0xaf, 0xff,
    0xfb,

    /* U+004D "M" */
    0x81, 0x0, 0x0, 0x0, 0x18, 0xac, 0x0, 0x0,
    0x0, 0xca, 0xaf, 0xa0, 0x0, 0xa, 0xfa, 0xaf,
    0xf9, 0x0, 0x8f, 0xfa, 0xaf, 0xef, 0x76, 0xfe,
    0xfa, 0xaf, 0x6e, 0xff, 0xe6, 0xfa, 0xaf, 0x53,
    0xff, 0x34, 0xfa, 0xaf, 0x50, 0x55, 0x5, 0xfa,
    0xaf, 0x50, 0x0, 0x5, 0xfa, 0xaf, 0x50, 0x0,
    0x5, 0xfa, 0xaf, 0x50, 0x0, 0x5, 0xfa,

    /* U+004E "N" */
    0x81, 0x0, 0x0, 0xbf, 0x3a, 0xc0, 0x0, 0xb,
    0xf3, 0xaf, 0xb0, 0x0, 0xbf, 0x3a, 0xff, 0xa0,
    0xb, 0xf3, 0xaf, 0xef, 0x90, 0xbf, 0x3a, 0xf6,
    0xef, 0x7b, 0xf3, 0xaf, 0x42, 0xef, 0xef, 0x3a,
    0xf5, 0x3, 0xff, 0xf3, 0xaf, 0x50, 0x4, 0xff,
    0x3a, 0xf5, 0x0, 0x5, 0xf3, 0xaf, 0x50, 0x0,
    0x6, 0x30,

    /* U+004F "O" */
    0x0, 0x2a, 0xef, 0xd7, 0x0, 0x2, 0xff, 0xcb,
    0xff, 0xa0, 0xc, 0xf9, 0x0, 0x2e, 0xf4, 0x1f,
    0xf1, 0x0, 0x8, 0xfa, 0x4f, 0xd0, 0x0, 0x5,
    0xfd, 0x5f, 0xc0, 0x0, 0x3, 0xfe, 0x4f, 0xd0,
    0x0, 0x4, 0xfd, 0x1f, 0xf1, 0x0, 0x8, 0xfa,
    0xc, 0xf9, 0x0, 0x2f, 0xf4, 0x2, 0xef, 0xdb,
    0xff, 0xa0, 0x0, 0x2a, 0xef, 0xd7, 0x0,

    /* U+0050 "P" */
    0xaf, 0xff, 0xd8, 0x10, 0xaf, 0xb9, 0xdf, 0xd0,
    0xaf, 0x60, 0xe, 0xf4, 0xaf, 0x60, 0xa, 0xf6,
    0xaf, 0x60, 0xb, 0xf5, 0xaf, 0x60, 0x1f, 0xf2,
    0xaf, 0xca, 0xef, 0x90, 0xaf, 0xff, 0xd7, 0x0,
    0xaf, 0x60, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0,
    0xaf, 0x60, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x2a, 0xef, 0xd7, 0x0, 0x2, 0xff, 0xcb,
    0xff, 0xa0, 0xc, 0xf9, 0x0, 0x2e, 0xf4, 0x1f,
    0xf1, 0x0, 0x8, 0xfa, 0x4f, 0xd0, 0x0, 0x5,
    0xfd, 0x5f, 0xc0, 0x0, 0x3, 0xfe, 0x4f, 0xd0,
    0x0, 0x4, 0xfc, 0x1f, 0xf1, 0x0, 0x8, 0xfa,
    0xc, 0xf9, 0x0, 0x2f, 0xf4, 0x2, 0xef, 0xdb,
    0xff, 0xa0, 0x0, 0x2a, 0xef, 0xf9, 0x0, 0x0,
    0x0, 0x5, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x30, 0x0, 0x0, 0x0, 0x31, 0x0,

    /* U+0052 "R" */
    0xaf, 0xff, 0xd9, 0x10, 0xaf, 0xb9, 0xdf, 0xd0,
    0xaf, 0x60, 0xe, 0xf4, 0xaf, 0x60, 0xa, 0xf6,
    0xaf, 0x60, 0xc, 0xf4, 0xaf, 0x60, 0x7f, 0xe0,
    0xaf, 0xff, 0xfe, 0x30, 0xaf, 0xaf, 0xf2, 0x0,
    0xaf, 0x69, 0xfc, 0x0, 0xaf, 0x60, 0xdf, 0x90,
    0xaf, 0x60, 0x2f, 0xf5,

    /* U+0053 "S" */
    0x0, 0x9e, 0xfd, 0x60, 0xa, 0xfe, 0xbf, 0xd0,
    0xf, 0xf2, 0x1, 0x30, 0xf, 0xf5, 0x0, 0x0,
    0x7, 0xff, 0x70, 0x0, 0x0, 0x7f, 0xfd, 0x30,
    0x0, 0x2, 0xbf, 0xe1, 0x0, 0x0, 0xc, 0xf6,
    0x7, 0x20, 0xb, 0xf7, 0x1f, 0xfc, 0xdf, 0xf2,
    0x5, 0xce, 0xfc, 0x30,

    /* U+0054 "T" */
    0xbf, 0xff, 0xff, 0xf8, 0x8c, 0xcf, 0xfc, 0xc6,
    0x0, 0x2f, 0xe0, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x2f, 0xe0, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x2f, 0xe0, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x2f, 0xe0, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x2f, 0xe0, 0x0,

    /* U+0055 "U" */
    0xff, 0x20, 0x3, 0xfe, 0xff, 0x20, 0x3, 0xfe,
    0xff, 0x20, 0x3, 0xfe, 0xff, 0x20, 0x3, 0xfe,
    0xff, 0x20, 0x3, 0xfe, 0xff, 0x20, 0x3, 0xfe,
    0xef, 0x20, 0x3, 0xfd, 0xef, 0x30, 0x4, 0xfd,
    0xbf, 0x80, 0x8, 0xfa, 0x4f, 0xfc, 0xcf, 0xf4,
    0x4, 0xce, 0xeb, 0x40,

    /* U+0056 "V" */
    0xe, 0xf3, 0x0, 0x6, 0xfb, 0x8, 0xf9, 0x0,
    0xc, 0xf5, 0x2, 0xff, 0x0, 0x2f, 0xe0, 0x0,
    0xcf, 0x50, 0x7f, 0x80, 0x0, 0x5f, 0xb0, 0xdf,
    0x20, 0x0, 0xe, 0xf3, 0xfb, 0x0, 0x0, 0x8,
    0xfd, 0xf5, 0x0, 0x0, 0x2, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0xbf, 0x80, 0x0, 0x0, 0x0, 0x5f,
    0x20, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0,

    /* U+0057 "W" */
    0xf, 0xf3, 0x0, 0xa, 0x0, 0x5, 0xfc, 0xa,
    0xf8, 0x0, 0x3f, 0x20, 0xa, 0xf7, 0x5, 0xfc,
    0x0, 0x9f, 0x80, 0xe, 0xf2, 0x0, 0xff, 0x10,
    0xef, 0xe0, 0x3f, 0xc0, 0x0, 0xaf, 0x65, 0xff,
    0xf4, 0x8f, 0x70, 0x0, 0x4f, 0xbb, 0xf5, 0xfa,
    0xcf, 0x20, 0x0, 0xe, 0xff, 0xa0, 0xdf, 0xfc,
    0x0, 0x0, 0x9, 0xff, 0x40, 0x6f, 0xf7, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0xf, 0xf1, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x9, 0xc0, 0x0, 0x0, 0x0,
    0x91, 0x0, 0x2, 0x70, 0x0,

    /* U+0058 "X" */
    0x8f, 0xd0, 0x0, 0xbf, 0x90, 0xef, 0x40, 0x3f,
    0xf1, 0x7, 0xfc, 0xa, 0xf8, 0x0, 0xd, 0xf5,
    0xfe, 0x0, 0x0, 0x5f, 0xff, 0x70, 0x0, 0x1,
    0xff, 0xf1, 0x0, 0x0, 0x8f, 0xff, 0x70, 0x0,
    0x1f, 0xf5, 0xfe, 0x10, 0x8, 0xfa, 0xb, 0xf8,
    0x1, 0xff, 0x30, 0x4f, 0xf1, 0x9f, 0xc0, 0x0,
    0xcf, 0xa0,

    /* U+0059 "Y" */
    0xe, 0xf4, 0x0, 0xa, 0xf9, 0x6, 0xfb, 0x0,
    0x1f, 0xf1, 0x0, 0xdf, 0x30, 0x9f, 0x80, 0x0,
    0x5f, 0xb1, 0xff, 0x10, 0x0, 0xd, 0xfb, 0xf7,
    0x0, 0x0, 0x4, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x0,
    0x0, 0x0, 0xbf, 0x50, 0x0, 0x0, 0x0, 0xbf,
    0x50, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x0,

    /* U+005A "Z" */
    0xf, 0xff, 0xff, 0xfb, 0xa, 0xbb, 0xbf, 0xf3,
    0x0, 0x0, 0x7f, 0xc0, 0x0, 0x0, 0xef, 0x40,
    0x0, 0x6, 0xfd, 0x0, 0x0, 0xe, 0xf5, 0x0,
    0x0, 0x6f, 0xd0, 0x0, 0x0, 0xdf, 0x60, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0xc, 0xfe, 0xbb, 0xb8,
    0x4f, 0xff, 0xff, 0xfb,

    /* U+005B "[" */
    0x4f, 0xff, 0x75, 0xf8, 0x21, 0x5f, 0x70, 0x5,
    0xf7, 0x0, 0x5f, 0x70, 0x5, 0xf7, 0x0, 0x5f,
    0x70, 0x5, 0xf7, 0x0, 0x5f, 0x70, 0x5, 0xf7,
    0x0, 0x5f, 0x70, 0x5, 0xf7, 0x0, 0x5f, 0x70,
    0x5, 0xf7, 0x0, 0x5f, 0xff, 0x70, 0x22, 0x21,

    /* U+005C "\\" */
    0x18, 0x20, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x6, 0xf2, 0x0, 0x0,
    0x2, 0xf6, 0x0, 0x0, 0x0, 0xdb, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x4f, 0x40, 0x0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x0, 0x6, 0xf2, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x0, 0x3f, 0x50, 0x0, 0x0, 0xe, 0x90,
    0x0, 0x0, 0xa, 0xe0,

    /* U+005D "]" */
    0x4f, 0xff, 0x70, 0x26, 0xf8, 0x0, 0x4f, 0x80,
    0x4, 0xf8, 0x0, 0x4f, 0x80, 0x4, 0xf8, 0x0,
    0x4f, 0x80, 0x4, 0xf8, 0x0, 0x4f, 0x80, 0x4,
    0xf8, 0x0, 0x4f, 0x80, 0x4, 0xf8, 0x0, 0x4f,
    0x80, 0x4, 0xf8, 0x4f, 0xff, 0x80, 0x22, 0x21,

    /* U+005E "^" */
    0x0, 0x7, 0x30, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x0, 0x9f, 0xf1, 0x0, 0x0, 0xed, 0xf6, 0x0,
    0x4, 0xf6, 0xdc, 0x0, 0x9, 0xf1, 0x9f, 0x20,
    0xe, 0xc0, 0x4f, 0x70, 0x4f, 0x70, 0xe, 0xc0,
    0xaf, 0x20, 0xa, 0xf2,

    /* U+005F "_" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x3, 0x33, 0x33, 0x33, 0x33,
    0x20,

    /* U+0060 "`" */
    0x12, 0x10, 0x4, 0xfd, 0x0, 0xa, 0xf5, 0x0,
    0x1e, 0xc0,

    /* U+0061 "a" */
    0x7, 0xce, 0xfb, 0x20, 0xcd, 0xad, 0xfc, 0x0,
    0x0, 0xf, 0xf0, 0x29, 0xef, 0xff, 0x1e, 0xf6,
    0x3f, 0xf5, 0xfa, 0x0, 0xff, 0x3f, 0xe5, 0xbf,
    0xf0, 0x8f, 0xe7, 0xcf,

    /* U+0062 "b" */
    0xcf, 0x20, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0xcf, 0x6d, 0xfb, 0x20, 0xcf, 0xfa, 0xdf, 0xc0,
    0xcf, 0x80, 0x1f, 0xf2, 0xcf, 0x40, 0xd, 0xf4,
    0xcf, 0x30, 0xc, 0xf4, 0xcf, 0x60, 0xf, 0xf1,
    0xcf, 0xd6, 0xaf, 0xb0, 0xcf, 0x4d, 0xfa, 0x10,

    /* U+0063 "c" */
    0x0, 0x7d, 0xfd, 0x60, 0x8f, 0xea, 0xe7, 0x1f,
    0xf2, 0x0, 0x4, 0xfd, 0x0, 0x0, 0x4f, 0xd0,
    0x0, 0x1, 0xff, 0x10, 0x0, 0xa, 0xfe, 0xad,
    0x80, 0x8, 0xef, 0xc5,

    /* U+0064 "d" */
    0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc,
    0x1, 0xbf, 0xe7, 0xfc, 0xb, 0xfe, 0xae, 0xfc,
    0x1f, 0xf1, 0x7, 0xfc, 0x4f, 0xc0, 0x3, 0xfc,
    0x4f, 0xc0, 0x3, 0xfc, 0x1f, 0xf0, 0x6, 0xfc,
    0xb, 0xfa, 0x6d, 0xfc, 0x1, 0xaf, 0xe4, 0xfc,

    /* U+0065 "e" */
    0x0, 0x7d, 0xfd, 0x50, 0x8, 0xfc, 0x8e, 0xf2,
    0x1f, 0xe0, 0x8, 0xf7, 0x4f, 0xff, 0xff, 0xf9,
    0x4f, 0xd3, 0x33, 0x31, 0x1f, 0xf1, 0x0, 0x10,
    0xa, 0xfd, 0x8a, 0xe0, 0x0, 0x8e, 0xfe, 0x91,

    /* U+0066 "f" */
    0x0, 0x9e, 0xf8, 0x7, 0xfe, 0xa8, 0xa, 0xf4,
    0x0, 0xb, 0xf3, 0x0, 0xcf, 0xff, 0xf2, 0x8e,
    0xfb, 0xa1, 0xb, 0xf3, 0x0, 0xb, 0xf3, 0x0,
    0xb, 0xf3, 0x0, 0xb, 0xf3, 0x0, 0xb, 0xf3,
    0x0, 0xb, 0xf3, 0x0,

    /* U+0067 "g" */
    0x1, 0xaf, 0xd5, 0xdc, 0xb, 0xfe, 0xae, 0xfc,
    0x1f, 0xf1, 0x7, 0xfc, 0x4f, 0xc0, 0x3, 0xfc,
    0x4f, 0xc0, 0x3, 0xfc, 0x2f, 0xf1, 0x7, 0xfc,
    0xb, 0xfd, 0x9d, 0xfc, 0x1, 0xaf, 0xe5, 0xfc,
    0x0, 0x0, 0x5, 0xf9, 0x2, 0xeb, 0xcf, 0xf3,
    0x3, 0xbe, 0xfc, 0x40,

    /* U+0068 "h" */
    0xcf, 0x20, 0x0, 0xc, 0xf2, 0x0, 0x0, 0xcf,
    0x20, 0x0, 0xc, 0xf2, 0x0, 0x0, 0xcf, 0x6d,
    0xfc, 0x1c, 0xff, 0xae, 0xfa, 0xcf, 0x60, 0x4f,
    0xdc, 0xf3, 0x2, 0xfe, 0xcf, 0x30, 0x2f, 0xec,
    0xf3, 0x2, 0xfe, 0xcf, 0x30, 0x2f, 0xec, 0xf3,
    0x2, 0xfe,

    /* U+0069 "i" */
    0xef, 0x5e, 0xf5, 0x11, 0xc, 0xf4, 0xcf, 0x4c,
    0xf4, 0xcf, 0x4c, 0xf4, 0xcf, 0x4c, 0xf4, 0xcf,
    0x40,

    /* U+006A "j" */
    0xe, 0xf5, 0xe, 0xf5, 0x1, 0x10, 0xc, 0xf3,
    0xc, 0xf3, 0xc, 0xf3, 0xc, 0xf3, 0xc, 0xf3,
    0xc, 0xf3, 0xc, 0xf3, 0xc, 0xf3, 0xd, 0xf2,
    0x4f, 0xf0, 0x8d, 0x50,

    /* U+006B "k" */
    0xcf, 0x20, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0xcf, 0x20, 0xcf, 0x60, 0xcf, 0x27, 0xfa, 0x0,
    0xcf, 0x4f, 0xd0, 0x0, 0xcf, 0xdf, 0x30, 0x0,
    0xcf, 0xcf, 0x90, 0x0, 0xcf, 0x3e, 0xf4, 0x0,
    0xcf, 0x25, 0xfe, 0x10, 0xcf, 0x20, 0xbf, 0xb0,

    /* U+006C "l" */
    0xcf, 0x2c, 0xf2, 0xcf, 0x2c, 0xf2, 0xcf, 0x2c,
    0xf2, 0xcf, 0x2c, 0xf2, 0xcf, 0x2c, 0xf2, 0xcf,
    0x2c, 0xf2,

    /* U+006D "m" */
    0xdf, 0x6d, 0xfc, 0x29, 0xfe, 0x70, 0xdf, 0xe7,
    0xcf, 0xfb, 0x7f, 0xf3, 0xdf, 0x50, 0x4f, 0xf0,
    0xa, 0xf6, 0xdf, 0x30, 0x3f, 0xd0, 0x9, 0xf7,
    0xdf, 0x30, 0x3f, 0xd0, 0x9, 0xf7, 0xdf, 0x30,
    0x3f, 0xd0, 0x9, 0xf7, 0xdf, 0x30, 0x3f, 0xd0,
    0x9, 0xf7, 0xdf, 0x30, 0x3f, 0xd0, 0x9, 0xf7,

    /* U+006E "n" */
    0xdf, 0x6d, 0xfb, 0x1d, 0xfe, 0x6c, 0xf9, 0xdf,
    0x50, 0x4f, 0xcd, 0xf3, 0x3, 0xfd, 0xdf, 0x30,
    0x3f, 0xdd, 0xf3, 0x3, 0xfd, 0xdf, 0x30, 0x3f,
    0xdd, 0xf3, 0x3, 0xfd,

    /* U+006F "o" */
    0x0, 0x8e, 0xfd, 0x60, 0x0, 0xaf, 0xd9, 0xff,
    0x50, 0x1f, 0xf1, 0x5, 0xfc, 0x4, 0xfd, 0x0,
    0x2f, 0xf0, 0x4f, 0xd0, 0x2, 0xff, 0x1, 0xff,
    0x10, 0x5f, 0xc0, 0xa, 0xfd, 0x9f, 0xf5, 0x0,
    0x8, 0xef, 0xd5, 0x0,

    /* U+0070 "p" */
    0xcf, 0x6d, 0xfb, 0x20, 0xcf, 0xe7, 0xbf, 0xc0,
    0xcf, 0x60, 0xf, 0xf2, 0xcf, 0x30, 0xd, 0xf3,
    0xcf, 0x30, 0xd, 0xf3, 0xcf, 0x70, 0x2f, 0xf1,
    0xcf, 0xe9, 0xdf, 0xa0, 0xcf, 0x6e, 0xfa, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0,

    /* U+0071 "q" */
    0x1, 0xaf, 0xe5, 0xfc, 0xb, 0xfe, 0xae, 0xfc,
    0x2f, 0xf1, 0x7, 0xfc, 0x4f, 0xd0, 0x3, 0xfc,
    0x4f, 0xd0, 0x3, 0xfc, 0x1f, 0xf1, 0x7, 0xfc,
    0xa, 0xfd, 0xad, 0xfc, 0x1, 0xaf, 0xd5, 0xfc,
    0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x2, 0xfc,

    /* U+0072 "r" */
    0xef, 0x4d, 0xf0, 0xef, 0xfe, 0xb0, 0xef, 0x80,
    0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef,
    0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0,

    /* U+0073 "s" */
    0x5, 0xdf, 0xe9, 0x1, 0xff, 0x8a, 0xd0, 0x3f,
    0xe1, 0x0, 0x0, 0xcf, 0xf9, 0x10, 0x0, 0x6d,
    0xfe, 0x10, 0x20, 0xb, 0xf6, 0x1f, 0xb9, 0xef,
    0x31, 0xae, 0xfd, 0x60,

    /* U+0074 "t" */
    0x0, 0x2, 0x0, 0x3, 0xf7, 0x0, 0x6, 0xf7,
    0x0, 0x8f, 0xff, 0xf6, 0x5d, 0xfc, 0xa4, 0x8,
    0xf7, 0x0, 0x8, 0xf7, 0x0, 0x8, 0xf7, 0x0,
    0x7, 0xf7, 0x0, 0x5, 0xfe, 0xba, 0x0, 0xbf,
    0xe8,

    /* U+0075 "u" */
    0xef, 0x20, 0x8f, 0x8e, 0xf2, 0x8, 0xf8, 0xef,
    0x20, 0x8f, 0x8e, 0xf2, 0x8, 0xf8, 0xef, 0x20,
    0x8f, 0x8d, 0xf2, 0x9, 0xf8, 0xaf, 0xa7, 0xff,
    0x82, 0xcf, 0xd7, 0xf8,

    /* U+0076 "v" */
    0xe, 0xf4, 0x0, 0xaf, 0x60, 0x7f, 0xa0, 0xf,
    0xf1, 0x1, 0xff, 0x5, 0xfa, 0x0, 0xa, 0xf5,
    0xaf, 0x40, 0x0, 0x4f, 0xae, 0xe0, 0x0, 0x0,
    0xdf, 0xf8, 0x0, 0x0, 0x7, 0xff, 0x20, 0x0,
    0x0, 0x1f, 0xc0, 0x0,

    /* U+0077 "w" */
    0xcf, 0x40, 0x3f, 0xb0, 0xb, 0xf2, 0x6f, 0x80,
    0x8f, 0xf0, 0xf, 0xd0, 0x1f, 0xc0, 0xce, 0xf4,
    0x3f, 0x80, 0xc, 0xf1, 0xf8, 0xf9, 0x7f, 0x30,
    0x7, 0xf8, 0xf3, 0xdd, 0xbe, 0x0, 0x2, 0xff,
    0xe0, 0x8f, 0xf9, 0x0, 0x0, 0xdf, 0xa0, 0x3f,
    0xf4, 0x0, 0x0, 0x8f, 0x50, 0xe, 0xf0, 0x0,

    /* U+0078 "x" */
    0x8f, 0xb0, 0x1f, 0xf1, 0x1e, 0xf2, 0x8f, 0x80,
    0x7, 0xfa, 0xee, 0x0, 0x0, 0xdf, 0xf6, 0x0,
    0x0, 0xdf, 0xf7, 0x0, 0x6, 0xfa, 0xff, 0x10,
    0xe, 0xf1, 0x9f, 0x90, 0x8f, 0xa0, 0x1f, 0xf2,

    /* U+0079 "y" */
    0xe, 0xf4, 0x0, 0xaf, 0x60, 0x7f, 0xa0, 0xf,
    0xf1, 0x1, 0xff, 0x5, 0xfa, 0x0, 0xa, 0xf4,
    0xaf, 0x40, 0x0, 0x4f, 0x9e, 0xe0, 0x0, 0x0,
    0xdf, 0xf8, 0x0, 0x0, 0x6, 0xff, 0x20, 0x0,
    0x0, 0x3f, 0xc0, 0x0, 0x0, 0x9, 0xf6, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x3c, 0x80,
    0x0, 0x0,

    /* U+007A "z" */
    0x2f, 0xff, 0xff, 0x90, 0x77, 0xaf, 0xf1, 0x0,
    0xc, 0xf8, 0x0, 0x4, 0xfe, 0x0, 0x0, 0xdf,
    0x60, 0x0, 0x6f, 0xd0, 0x0, 0xe, 0xfa, 0x66,
    0x38, 0xff, 0xff, 0xf9,

    /* U+007B "{" */
    0x0, 0x1a, 0xf9, 0x0, 0xcf, 0x20, 0x1, 0xfb,
    0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2,
    0xf9, 0x0, 0x7, 0xf6, 0x0, 0x9f, 0xa0, 0x0,
    0x29, 0xf4, 0x0, 0x2, 0xf9, 0x0, 0x2, 0xfa,
    0x0, 0x2, 0xfa, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x1b, 0xf9,

    /* U+007C "|" */
    0x5a, 0x18, 0xf2, 0x8f, 0x28, 0xf2, 0x8f, 0x28,
    0xf2, 0x8f, 0x28, 0xf2, 0x8f, 0x28, 0xf2, 0x8f,
    0x28, 0xf2, 0x8f, 0x28, 0xf2, 0x8f, 0x28, 0xf2,

    /* U+007D "}" */
    0x6f, 0xc2, 0x0, 0x1, 0xee, 0x0, 0x0, 0x8f,
    0x40, 0x0, 0x7f, 0x50, 0x0, 0x7f, 0x50, 0x0,
    0x6f, 0x50, 0x0, 0x3f, 0x90, 0x0, 0x8, 0xfc,
    0x0, 0x2f, 0xb3, 0x0, 0x6f, 0x50, 0x0, 0x7f,
    0x50, 0x0, 0x7f, 0x50, 0x0, 0x8f, 0x40, 0x1,
    0xde, 0x0, 0x7f, 0xc3, 0x0,

    /* U+007E "~" */
    0x6, 0xee, 0x80, 0x7, 0x45, 0xfc, 0xcf, 0xda,
    0xf8, 0x39, 0x0, 0x6d, 0xf8, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0xdc,
    0x0, 0x0, 0x0, 0x0, 0x16, 0xbf, 0xff, 0xff,
    0x0, 0x0, 0x3, 0x8d, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xfa, 0x51, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x84, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x2b, 0xee, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x2b, 0xee, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xfd,
    0xdf, 0xff, 0xff, 0x0, 0x0, 0x2b, 0xff, 0xb2,
    0xdf, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,

    /* U+F00B "" */
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xc0,
    0x1b, 0xa0, 0x0, 0x0, 0xb, 0xff, 0xfc, 0x0,
    0xcf, 0xfb, 0x0, 0x0, 0xbf, 0xff, 0xc0, 0x0,
    0xbf, 0xff, 0xb0, 0xb, 0xff, 0xfc, 0x0, 0x0,
    0xc, 0xff, 0xfb, 0xbf, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x3, 0x0, 0x0, 0x0, 0x3, 0x8, 0xfc, 0x10,
    0x0, 0x1c, 0xf8, 0xff, 0xfc, 0x10, 0x1c, 0xff,
    0xf5, 0xff, 0xfc, 0x2c, 0xff, 0xf5, 0x5, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x5, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x1d, 0xff, 0xfd, 0x10, 0x0, 0x1c,
    0xff, 0xff, 0xfc, 0x10, 0x1c, 0xff, 0xf9, 0xff,
    0xfc, 0x1c, 0xff, 0xf5, 0x5, 0xff, 0xfc, 0xdf,
    0xf5, 0x0, 0x5, 0xff, 0xd1, 0xa4, 0x0, 0x0,
    0x4, 0xa1,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x10, 0x6f, 0xf1, 0x3, 0x10, 0x0,
    0x0, 0x5f, 0xd0, 0x6f, 0xf1, 0x3f, 0xd1, 0x0,
    0x3, 0xff, 0xf1, 0x6f, 0xf1, 0x5f, 0xfd, 0x0,
    0xd, 0xff, 0x40, 0x6f, 0xf1, 0x9, 0xff, 0x70,
    0x4f, 0xf7, 0x0, 0x6f, 0xf1, 0x0, 0xcf, 0xe0,
    0x9f, 0xf0, 0x0, 0x6f, 0xf1, 0x0, 0x5f, 0xf3,
    0xbf, 0xc0, 0x0, 0x6f, 0xf1, 0x0, 0x2f, 0xf5,
    0xbf, 0xc0, 0x0, 0x4f, 0xe0, 0x0, 0x1f, 0xf6,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf0,
    0xf, 0xfe, 0x10, 0x0, 0x0, 0x5, 0xff, 0xa0,
    0x6, 0xff, 0xd3, 0x0, 0x0, 0x7f, 0xff, 0x20,
    0x0, 0x9f, 0xff, 0xda, 0xbe, 0xff, 0xf4, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x17, 0xbd, 0xca, 0x50, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x4, 0xfd, 0xdf, 0xff, 0xff, 0xfd, 0xef, 0x40,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4, 0xfe, 0xdf, 0xff, 0xff, 0xfd, 0xdf, 0x40,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x3, 0xdd, 0x30, 0x3f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf5, 0x4f,
    0xf4, 0x0, 0x0, 0x0, 0x9, 0xff, 0x99, 0xff,
    0xbf, 0xf4, 0x0, 0x0, 0x1, 0xbf, 0xf6, 0x22,
    0x6f, 0xff, 0xf4, 0x0, 0x0, 0x2d, 0xfe, 0x35,
    0xff, 0x53, 0xef, 0xf4, 0x0, 0x4, 0xff, 0xc1,
    0x8f, 0xff, 0xf8, 0x1c, 0xfe, 0x40, 0x7f, 0xfa,
    0x1a, 0xff, 0xff, 0xff, 0xa1, 0xaf, 0xf7, 0xcf,
    0x82, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x28, 0xfc,
    0x14, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x41, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xf, 0xff, 0xf9, 0x0, 0x8f,
    0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8, 0x0,
    0x8f, 0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8,
    0x0, 0x8f, 0xff, 0xf0, 0x0, 0x0, 0xe, 0xff,
    0xf6, 0x0, 0x6f, 0xff, 0xe0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0xdf, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xfc, 0x1b, 0xb1, 0xcf, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xc2, 0x2c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F01C "" */
    0x0, 0x4, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40,
    0x0, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0x0, 0x0, 0xaf, 0xb0, 0x0, 0x0, 0x0,
    0xb, 0xfa, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x50, 0x1e, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xe1, 0xaf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xfa, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F021 "" */
    0x0, 0x0, 0x6, 0xbd, 0xda, 0x50, 0x2, 0xff,
    0x0, 0x5, 0xef, 0xff, 0xff, 0xfe, 0x42, 0xff,
    0x0, 0x7f, 0xff, 0xa7, 0x7b, 0xff, 0xf9, 0xff,
    0x5, 0xff, 0xc1, 0x0, 0x0, 0x2c, 0xff, 0xff,
    0xe, 0xfc, 0x0, 0x0, 0x2, 0x22, 0xdf, 0xff,
    0x5f, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x8f, 0xb0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb, 0xf8,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x2f, 0xf4,
    0xff, 0xfd, 0x22, 0x20, 0x0, 0x0, 0xcf, 0xe0,
    0xff, 0xff, 0xc2, 0x0, 0x0, 0x2c, 0xff, 0x40,
    0xff, 0x9f, 0xff, 0xb7, 0x6a, 0xff, 0xf7, 0x0,
    0xff, 0x24, 0xdf, 0xff, 0xff, 0xfe, 0x50, 0x0,
    0xff, 0x20, 0x5, 0xac, 0xdb, 0x60, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8, 0xff, 0x0, 0x0, 0x8f, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x9f, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0x1, 0x50, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x0, 0xae,
    0xff, 0xff, 0xff, 0xff, 0x5, 0xf8, 0xdf, 0xff,
    0xff, 0xff, 0x2, 0x60, 0x0, 0x0, 0x9f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x3, 0xee, 0x10, 0x0, 0x0, 0x8, 0xff, 0x0,
    0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x5, 0xfc, 0x7, 0xf4, 0xdf, 0xff, 0xff,
    0xff, 0x2, 0x50, 0x5f, 0x60, 0xf9, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xd, 0xc0, 0xbd, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xf0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xe0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x6, 0xf7, 0xd,
    0xc0, 0xad, 0xdf, 0xff, 0xff, 0xff, 0x2, 0x50,
    0x5f, 0x60, 0xe9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x5, 0xfc, 0x6, 0xf4, 0x0, 0x0, 0x9, 0xff,
    0x0, 0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x2, 0xee, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10, 0x0,

    /* U+F03E "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0xc, 0xff, 0xff, 0xee, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xfe, 0x12, 0xef, 0xff,
    0xff, 0xfc, 0xff, 0xff, 0xe1, 0x0, 0x2e, 0xff,
    0xff, 0xfe, 0x4e, 0xfe, 0x10, 0x0, 0x2, 0xff,
    0xff, 0xe1, 0x2, 0xc1, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F043 "" */
    0x0, 0x0, 0x4e, 0x40, 0x0, 0x0, 0x0, 0xb,
    0xfb, 0x0, 0x0, 0x0, 0x1, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0x90, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0x30, 0x0, 0xc, 0xff, 0xff, 0xfc,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xf8, 0x2, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
    0x2f, 0xff, 0xff, 0xff, 0xfe, 0xf2, 0xbf, 0xff,
    0xff, 0xfe, 0x9f, 0xa1, 0xbf, 0xff, 0xff, 0x92,
    0xff, 0xa2, 0x2f, 0xff, 0xf2, 0x4, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x2, 0x9e, 0xfe, 0x92, 0x0,

    /* U+F048 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30, 0x0,
    0x1, 0xcc, 0xff, 0x40, 0x0, 0x2d, 0xff, 0xff,
    0x40, 0x3, 0xef, 0xff, 0xff, 0x40, 0x3f, 0xff,
    0xff, 0xff, 0x44, 0xff, 0xff, 0xff, 0xff, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0x45, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x4f, 0xff, 0xff, 0xff, 0x40, 0x3, 0xef,
    0xff, 0xff, 0x40, 0x0, 0x2d, 0xff, 0xff, 0x30,
    0x0, 0x1, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xfd,
    0x40, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0x10, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd5, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x20,
    0x0, 0x0, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x8e, 0xa1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0x7f, 0xff, 0xf7, 0x0, 0x7f, 0xff,
    0xf7,

    /* U+F04D "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x10, 0x0,
    0x3, 0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xff,
    0xfe, 0x30, 0x4, 0xff, 0xff, 0xff, 0xf4, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x54, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0xff, 0xff, 0xff, 0xff, 0x44, 0xff, 0xff,
    0xff, 0xf3, 0x4, 0xff, 0xff, 0xfe, 0x30, 0x4,
    0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xcc, 0x10,
    0x0, 0x3, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x1a, 0x40, 0x0, 0x0, 0x1,
    0xdf, 0xf0, 0x0, 0x0, 0x1d, 0xff, 0xa0, 0x0,
    0x1, 0xdf, 0xfa, 0x0, 0x0, 0x1d, 0xff, 0xa0,
    0x0, 0x1, 0xdf, 0xfa, 0x0, 0x0, 0xc, 0xff,
    0xa0, 0x0, 0x0, 0xd, 0xff, 0x80, 0x0, 0x0,
    0x1, 0xdf, 0xf8, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0x80, 0x0, 0x0, 0x1, 0xdf, 0xf8, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0x80, 0x0, 0x0, 0x1, 0xdf,
    0xf0, 0x0, 0x0, 0x0, 0x1b, 0x50,

    /* U+F054 "" */
    0x4, 0xa1, 0x0, 0x0, 0x0, 0xf, 0xfc, 0x10,
    0x0, 0x0, 0xa, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0xaf, 0xfc, 0x10, 0x0, 0x0, 0xa, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0xaf, 0xfc, 0x10, 0x0, 0x0,
    0xa, 0xff, 0xc0, 0x0, 0x0, 0x8, 0xff, 0xd0,
    0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8, 0xff,
    0xd1, 0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8,
    0xff, 0xd1, 0x0, 0x0, 0xf, 0xfd, 0x10, 0x0,
    0x0, 0x5, 0xb1, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x4, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x48, 0x88, 0x8c, 0xff, 0xc8,
    0x88, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x48, 0x88, 0x8c, 0xff, 0xc8, 0x88, 0x84, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x40,
    0x0, 0x0,

    /* U+F068 "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x41, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb7,

    /* U+F06E "" */
    0x0, 0x0, 0x5, 0xad, 0xff, 0xda, 0x50, 0x0,
    0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf, 0xfd,
    0x40, 0x0, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4,
    0xef, 0xf7, 0x0, 0x7, 0xff, 0xf4, 0x0, 0x9e,
    0x80, 0x4f, 0xff, 0x70, 0x4f, 0xff, 0xc0, 0x0,
    0xaf, 0xf8, 0xc, 0xff, 0xf4, 0xdf, 0xff, 0x80,
    0x9a, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0xdf, 0xff,
    0x80, 0xef, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0x4f,
    0xff, 0xc0, 0x8f, 0xff, 0xf8, 0xc, 0xff, 0xf4,
    0x7, 0xff, 0xf4, 0x8, 0xee, 0x80, 0x4f, 0xff,
    0x70, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4, 0xef,
    0xf8, 0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf,
    0xfd, 0x40, 0x0, 0x0, 0x0, 0x5, 0xad, 0xff,
    0xda, 0x50, 0x0, 0x0,

    /* U+F070 "" */
    0x8c, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0x80, 0x49,
    0xdf, 0xfd, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xd8, 0x8c, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x4, 0xef, 0xf8, 0x0, 0x0, 0x4e, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x1c, 0xff, 0x69, 0xe8,
    0x4, 0xff, 0xf7, 0x0, 0x4, 0xe3, 0x0, 0x9f,
    0xfe, 0xff, 0x80, 0xcf, 0xff, 0x40, 0xd, 0xff,
    0x70, 0x5, 0xff, 0xff, 0xe0, 0x8f, 0xff, 0xd0,
    0xd, 0xff, 0xf7, 0x0, 0x2d, 0xff, 0xe0, 0x8f,
    0xff, 0xd0, 0x4, 0xff, 0xfc, 0x0, 0x0, 0xaf,
    0xf8, 0xcf, 0xff, 0x30, 0x0, 0x7f, 0xff, 0x40,
    0x0, 0x6, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x8,
    0xff, 0xf4, 0x0, 0x0, 0x3e, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x4d, 0xff, 0xc8, 0x82, 0x1, 0xbf,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xdf, 0xfc,
    0x10, 0x8, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xc8,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xd8, 0x8d,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xa0, 0xa, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xb0, 0xb, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xc0, 0xc, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xd0, 0xd,
    0xff, 0xff, 0x50, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xf9, 0x9f, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xe2, 0x2e, 0xff, 0xff, 0xf8, 0x0,
    0x2, 0xff, 0xff, 0xff, 0x90, 0x9, 0xff, 0xff,
    0xff, 0x10, 0xa, 0xff, 0xff, 0xff, 0xe3, 0x3e,
    0xff, 0xff, 0xff, 0xa0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0x78, 0x8e, 0xff, 0x15, 0xff, 0xe8, 0xff, 0xe2,
    0x0, 0x2, 0xe5, 0x4f, 0xfe, 0x20, 0xfe, 0x20,
    0x0, 0x0, 0x13, 0xff, 0xf3, 0x0, 0x52, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0x31, 0x0, 0x52, 0x0,
    0x0, 0x2, 0xef, 0xf4, 0x5e, 0x20, 0xfe, 0x20,
    0x78, 0x8e, 0xff, 0x51, 0xff, 0xe8, 0xff, 0xe2,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x1d, 0xff, 0x99,
    0xff, 0xd1, 0x0, 0x1, 0xdf, 0xf9, 0x0, 0x9f,
    0xfd, 0x10, 0x1d, 0xff, 0x90, 0x0, 0x9, 0xff,
    0xd1, 0xbf, 0xf9, 0x0, 0x0, 0x0, 0x9f, 0xfb,
    0x5f, 0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F078 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0xbf, 0xf9,
    0x0, 0x0, 0x0, 0x9f, 0xfb, 0x1d, 0xff, 0x90,
    0x0, 0x9, 0xff, 0xd1, 0x1, 0xdf, 0xf9, 0x0,
    0x9f, 0xfd, 0x10, 0x0, 0x1d, 0xff, 0x99, 0xff,
    0xd1, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xfd, 0x10,
    0xef, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x1d, 0xff,
    0xff, 0xd1, 0xaf, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x6b, 0x1f, 0xf1, 0xb6, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x6b, 0x1f,
    0xf1, 0xb6, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xfa, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xfe, 0x1, 0xdf, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F07B "" */
    0x8f, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xf0, 0xdf, 0xfd, 0xf, 0xff, 0xfd,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xea,
    0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0x30, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x4f, 0xff, 0x90, 0x0, 0x2, 0x8f,
    0xf3, 0x0, 0x6f, 0xff, 0xd0, 0x0, 0xa, 0xff,
    0xff, 0xe4, 0xbf, 0xff, 0xd1, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xfb, 0x30, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xdb, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C4 "" */
    0x8, 0xee, 0x80, 0x0, 0x0, 0x6, 0x61, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x2d, 0xff, 0xd0, 0xef,
    0x33, 0xfe, 0x0, 0x2e, 0xff, 0xf3, 0xe, 0xf3,
    0x3f, 0xe0, 0x2e, 0xff, 0xf3, 0x0, 0x8f, 0xff,
    0xff, 0x6e, 0xff, 0xf3, 0x0, 0x0, 0x8e, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x8, 0xef, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x8, 0xff, 0xff, 0xf6, 0xef,
    0xff, 0x30, 0x0, 0xef, 0x33, 0xfe, 0x2, 0xef,
    0xff, 0x30, 0xe, 0xf3, 0x3f, 0xe0, 0x2, 0xef,
    0xff, 0x30, 0x8f, 0xff, 0xf8, 0x0, 0x2, 0xdf,
    0xfd, 0x0, 0x8e, 0xe8, 0x0, 0x0, 0x0, 0x66,
    0x10,

    /* U+F0C5 "" */
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xd, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xf, 0xd1, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf, 0xfd, 0xdf, 0xf0, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xff, 0xf0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdf, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,

    /* U+F0C7 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0xff, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xd1, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfc, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x11, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x11, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F0C9 "" */
    0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x12, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x21, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x12, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x12, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x21, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x12, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x21,

    /* U+F0E0 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0xd2, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x2d,
    0xff, 0x62, 0xcf, 0xff, 0xff, 0xfc, 0x26, 0xff,
    0xff, 0xfa, 0x18, 0xff, 0xff, 0x81, 0xaf, 0xff,
    0xff, 0xff, 0xe3, 0x4d, 0xd4, 0x3e, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x81, 0x18, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F0E7 "" */
    0x0, 0xdf, 0xff, 0xfd, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x3, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xd0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0xe, 0xff, 0xff, 0xff, 0xff, 0x20,
    0xd, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xe0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x2f, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x4, 0xde, 0x40, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0x99, 0xff, 0xfd, 0x0, 0x0, 0xff, 0xff,
    0x99, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xd, 0xff, 0xff,
    0xd, 0x10, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf,
    0xd1, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf, 0xfd,
    0xff, 0xff, 0xf, 0xff, 0xff, 0x20, 0x0, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xfd,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x30, 0x0, 0x0, 0x0, 0x1,
    0xbf, 0xff, 0xfc, 0x20, 0x0, 0x0, 0x1e, 0xff,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe1, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xee, 0x40, 0x0, 0x0,

    /* U+F11C "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x8,
    0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff, 0xf8,
    0x8, 0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf, 0x0,
    0xff, 0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xaf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xdf, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x17,
    0xef, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x18,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x2a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F15B "" */
    0xdf, 0xff, 0xff, 0xf0, 0xd1, 0x0, 0xff, 0xff,
    0xff, 0xf0, 0xfd, 0x10, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xd1, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x9c, 0xef, 0xfe,
    0xc9, 0x40, 0x0, 0x0, 0x0, 0x7, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x70, 0x0, 0x4, 0xdf,
    0xff, 0xfc, 0xa8, 0x8a, 0xcf, 0xff, 0xfd, 0x40,
    0x6f, 0xff, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x5d,
    0xff, 0xf6, 0xcf, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xfc, 0x1a, 0x30, 0x0, 0x5a,
    0xdf, 0xfd, 0xa5, 0x0, 0x3, 0xa1, 0x0, 0x0,
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xa8, 0x8a, 0xef, 0xff,
    0x50, 0x0, 0x0, 0x1, 0xdf, 0x70, 0x0, 0x0,
    0x7, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x12, 0x0,
    0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F241 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F242 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F243 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F244 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb9, 0x29, 0xfe, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xdf, 0x80, 0xa,
    0x90, 0x0, 0x0, 0x0, 0x3, 0x70, 0x0, 0xdf,
    0xff, 0x77, 0xf7, 0x55, 0x55, 0x55, 0x55, 0x8f,
    0xd3, 0xf, 0xff, 0xfd, 0xcc, 0xdf, 0xdc, 0xcc,
    0xcc, 0xcd, 0xff, 0xb0, 0x8f, 0xfe, 0x10, 0x0,
    0xaa, 0x0, 0x0, 0x0, 0x4d, 0x40, 0x0, 0x46,
    0x10, 0x0, 0x1, 0xf2, 0x2, 0x33, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb1, 0xcf,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x22,
    0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x18, 0xdf, 0xfd, 0x92, 0x0, 0x2, 0xef,
    0xfb, 0xef, 0xff, 0x40, 0xd, 0xff, 0xfa, 0x2e,
    0xff, 0xe0, 0x4f, 0xff, 0xfa, 0x3, 0xff, 0xf5,
    0x9f, 0xfa, 0xfa, 0x35, 0x4f, 0xfa, 0xcf, 0xc0,
    0x8a, 0x3d, 0xb, 0xfd, 0xef, 0xfb, 0x3, 0x11,
    0x8f, 0xfe, 0xff, 0xff, 0xb0, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xd1, 0x8, 0xff, 0xff, 0xef, 0xfd,
    0x11, 0x10, 0x9f, 0xff, 0xdf, 0xd1, 0x59, 0x3b,
    0xb, 0xfd, 0xaf, 0xd6, 0xfa, 0x37, 0x1d, 0xfb,
    0x5f, 0xff, 0xfa, 0x1, 0xdf, 0xf7, 0xd, 0xff,
    0xfa, 0x1d, 0xff, 0xf1, 0x3, 0xef, 0xfc, 0xdf,
    0xff, 0x50, 0x0, 0x18, 0xdf, 0xfe, 0xa3, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x7f, 0xff, 0xf7, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9, 0x9f,
    0xf0, 0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0,
    0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf,
    0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8,
    0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f,
    0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f, 0x88,
    0xf8, 0x8f, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9,
    0x9f, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x7a, 0x1d,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xfa,
    0x1d, 0xff, 0x70, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xfa, 0x1d, 0x70, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xde, 0xdb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe4, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x1d, 0xff, 0xff,
    0xfa, 0xef, 0xfe, 0xaf, 0xff, 0xff, 0x1, 0xdf,
    0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa, 0xff, 0xff,
    0x1d, 0xff, 0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e,
    0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x2, 0xef, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x2, 0xef, 0xff, 0xff, 0x1d, 0xff,
    0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e, 0xff, 0xff,
    0x1, 0xdf, 0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa,
    0xff, 0xff, 0x0, 0x1d, 0xff, 0xff, 0xfa, 0xef,
    0xfe, 0xaf, 0xff, 0xff, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F7C2 "" */
    0x0, 0x7, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xfe, 0x7, 0xf8, 0xf, 0xb,
    0x40, 0xff, 0x7f, 0xf8, 0xf, 0xb, 0x40, 0xff,
    0xff, 0xf8, 0xf, 0xb, 0x40, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x2,
    0xef, 0x10, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x0, 0xcf, 0xf1, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x11, 0xcf, 0xff, 0x77, 0x77, 0x77,
    0x77, 0xbf, 0xf1, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x17, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 49, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 81, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18, .adv_w = 128, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 36, .adv_w = 158, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 91, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 139, .adv_w = 231, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 216, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 276, .adv_w = 74, .box_w = 3, .box_h = 6, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 285, .adv_w = 99, .box_w = 5, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 325, .adv_w = 99, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 373, .adv_w = 127, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 401, .adv_w = 146, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 437, .adv_w = 57, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 445, .adv_w = 116, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 451, .adv_w = 55, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 456, .adv_w = 92, .box_w = 8, .box_h = 17, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 524, .adv_w = 148, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 574, .adv_w = 80, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 592, .adv_w = 144, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 642, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 692, .adv_w = 156, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 747, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 797, .adv_w = 159, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 852, .adv_w = 135, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 902, .adv_w = 158, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 957, .adv_w = 159, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1012, .adv_w = 55, .box_w = 3, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1024, .adv_w = 55, .box_w = 3, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1041, .adv_w = 136, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1073, .adv_w = 146, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1097, .adv_w = 136, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1129, .adv_w = 109, .box_w = 8, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1177, .adv_w = 190, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1249, .adv_w = 145, .box_w = 11, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1310, .adv_w = 145, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1354, .adv_w = 135, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1404, .adv_w = 155, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1454, .adv_w = 130, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1493, .adv_w = 119, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1532, .adv_w = 161, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1587, .adv_w = 168, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1637, .adv_w = 74, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1654, .adv_w = 102, .box_w = 7, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1693, .adv_w = 153, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1743, .adv_w = 114, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1776, .adv_w = 192, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1831, .adv_w = 169, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1881, .adv_w = 168, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1936, .adv_w = 140, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1980, .adv_w = 168, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2050, .adv_w = 148, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2094, .adv_w = 129, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2138, .adv_w = 125, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2182, .adv_w = 159, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2226, .adv_w = 141, .box_w = 10, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2281, .adv_w = 205, .box_w = 14, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2358, .adv_w = 145, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2408, .adv_w = 138, .box_w = 10, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2463, .adv_w = 134, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2507, .adv_w = 99, .box_w = 5, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2547, .adv_w = 92, .box_w = 8, .box_h = 17, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2615, .adv_w = 99, .box_w = 5, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2655, .adv_w = 120, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2691, .adv_w = 154, .box_w = 11, .box_h = 3, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 2708, .adv_w = 70, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 2718, .adv_w = 127, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2746, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2794, .adv_w = 115, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2822, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2870, .adv_w = 133, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2902, .adv_w = 89, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2938, .adv_w = 143, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2982, .adv_w = 146, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3024, .adv_w = 72, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3041, .adv_w = 71, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3069, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3117, .adv_w = 70, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3135, .adv_w = 217, .box_w = 12, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3183, .adv_w = 143, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3211, .adv_w = 139, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3247, .adv_w = 144, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3291, .adv_w = 145, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3335, .adv_w = 98, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3359, .adv_w = 112, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3387, .adv_w = 100, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3420, .adv_w = 139, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3448, .adv_w = 121, .box_w = 9, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3484, .adv_w = 183, .box_w = 12, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3532, .adv_w = 122, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3564, .adv_w = 121, .box_w = 9, .box_h = 11, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 3614, .adv_w = 114, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3642, .adv_w = 100, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3687, .adv_w = 106, .box_w = 3, .box_h = 16, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 3711, .adv_w = 99, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3756, .adv_w = 147, .box_w = 9, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3770, .adv_w = 256, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3906, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4002, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4114, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4210, .adv_w = 176, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4276, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4404, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4532, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4658, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4786, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4894, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5022, .adv_w = 128, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5078, .adv_w = 192, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5162, .adv_w = 288, .box_w = 18, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5306, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5402, .adv_w = 176, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5490, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 5570, .adv_w = 224, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5696, .adv_w = 224, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5801, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5899, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 5979, .adv_w = 224, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 6091, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6161, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6231, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6329, .adv_w = 224, .box_w = 14, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 6357, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6465, .adv_w = 320, .box_w = 20, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6625, .adv_w = 288, .box_w = 20, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 6785, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6913, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 6983, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 7053, .adv_w = 320, .box_w = 20, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7193, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7289, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7417, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 7562, .adv_w = 224, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7667, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7779, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7877, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7975, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8071, .adv_w = 160, .box_w = 12, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 8167, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8279, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8391, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8499, .adv_w = 256, .box_w = 18, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 8661, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8757, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8907, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 9007, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 9107, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 9207, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 9307, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 9407, .adv_w = 320, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9554, .adv_w = 224, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 9650, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9762, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 9907, .adv_w = 320, .box_w = 20, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10027, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10123, .adv_w = 258, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x42,
    0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53,
    0x66, 0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77,
    0x78, 0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xc8,
    0xdf, 0xe6, 0xe9, 0xf2, 0x11b, 0x123, 0x15a, 0x1ea,
    0x23f, 0x240, 0x241, 0x242, 0x243, 0x286, 0x292, 0x2ec,
    0x303, 0x559, 0x7c1, 0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 60, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 0, 1, 0, 0, 0, 2,
    1, 3, 0, 4, 0, 5, 6, 5,
    0, 0, 0, 0, 0, 7, 0, 0,
    0, 0, 0, 5, 5, 0, 0, 0,
    0, 0, 8, 9, 10, 11, 12, 13,
    14, 0, 0, 0, 15, 16, 0, 0,
    11, 17, 11, 18, 19, 20, 0, 21,
    22, 23, 24, 25, 26, 0, 0, 0,
    0, 0, 27, 28, 29, 30, 31, 32,
    33, 27, 34, 35, 36, 30, 27, 27,
    28, 28, 37, 38, 39, 40, 41, 42,
    43, 44, 43, 45, 46, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 1, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    0, 0, 0, 0, 0, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 0, 15,
    16, 17, 18, 19, 0, 0, 20, 0,
    0, 0, 21, 22, 23, 23, 23, 24,
    23, 22, 25, 26, 22, 22, 27, 27,
    23, 28, 23, 27, 29, 30, 31, 32,
    33, 34, 35, 36, 0, 0, 20, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, -18,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0,
    0, -5, -3, -3, 0, -3, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 8,
    0, 14, 0, 0, 0, 0, 0, -8,
    -8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -31, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, -8,
    0, -8, -5, -5, -5, -8, -3, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 5, 5, 0, 5, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, 0, 0, 0, -13, 0, -1, 8,
    0, -9, -12, -6, 3, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, -3, 3, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -8, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    -5, -1, 3, 0, 0, -3, -3, 0,
    0, -4, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    5, -12, 0, -13, 0, 3, 3, 3,
    3, 4, 0, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, 0, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -8, 0,
    0, 0, 0, 0, -3, -5, 0, -5,
    -5, 0, -8, 0, 0, -23, 0, 0,
    0, 0, -8, 0, -18, 8, 0, 5,
    0, -10, -10, -10, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -23, 0, 0,
    0, -9, 3, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 6,
    3, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -23, -8, 0, 5, -9, -3, -8,
    0, 0, 0, 3, 0, 3, 0, 0,
    -13, 0, -13, 0, 0, 0, -12, 0,
    -13, 0, -10, -8, -8, -8, -8, -8,
    0, 0, 0, 0, 0, 0, -5, 0,
    8, -12, -3, -9, -1, 0, 0, -8,
    -8, -8, 0, 0, -10, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 8, -9, 0, -8,
    0, 3, -8, 0, -8, -8, 0, 0,
    -9, 0, -10, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    5, 3, -3, 5, 0, 0, -8, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -8, 0, 13, -12, -4, -8,
    0, 3, -8, -8, 0, -8, 0, 0,
    -13, 0, -14, 0, 0, 0, -10, -14,
    -8, 0, -9, 0, 0, -5, 0, -8,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 12, 0, 0,
    0, 0, 0, -8, -8, 0, 0, 0,
    0, 0, 0, -5, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, -13, -6, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    -5, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 3, 0, -8, 0, 0, 0,
    0, -14, -10, 0, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, 0, 0, 0, -10, -8, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -13, 0, -10,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5, 5, 3, 10,
    10, -15, -5, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    -1, 0, -8, 0, 0, 0, 0, 0,
    0, 0, -3, 0, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, 0, -13, -8, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    8, 0, 0, 0, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, 0, -12, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, -5, 0, 0, 0,
    0, -13, 0, 0, 0, -5, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, -10, 0, -5,
    0, -14, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, -8,
    0, 0, 5, 0, -5, -4, 0, 0,
    0, -8, 0, 0, 0, 0, 0, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, -8, 0, 0, 5, 0,
    -5, -4, 0, 0, 0, -5, 0, 0,
    0, 0, 0, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, -10, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, 0, -10, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 14, 0, 0,
    0, 0, 0, -8, -8, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 46,
    .right_class_cnt     = 36,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t lv_font_Alatsi_Regular_16 = {
#else
lv_font_t lv_font_Alatsi_Regular_16 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 19,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = 0,
    .underline_thickness = 2,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if LV_FONT_ALATSI_REGULAR_16*/

